/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.trust;

import java.security.Principal;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.rt.security.saml.claims.SAMLSecurityContext;
import org.apache.cxf.rt.security.saml.utils.SAMLUtils;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.wss4j.common.principal.WSUsernameTokenPrincipalImpl;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import org.w3c.dom.Document;

public class AuthPolicyValidatingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AuthPolicyValidatingInterceptor.class);
    private static final Logger LOG = LogUtils.getL7dLogger(AuthPolicyValidatingInterceptor.class);
    private Validator validator;

    public AuthPolicyValidatingInterceptor() {
        this("unmarshal");
    }

    public AuthPolicyValidatingInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        AuthorizationPolicy policy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class);
        if (policy == null || policy.getUserName() == null || policy.getPassword() == null) {
            String name = null;
            if (policy != null) {
                name = policy.getUserName();
            }
            org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("NO_USER_PASSWORD", BUNDLE, new Object[]{name});
            LOG.warning(errorMsg.toString());
            throw new SecurityException(errorMsg.toString());
        }
        try {
            UsernameToken token = this.convertPolicyToToken(policy);
            Credential credential = new Credential();
            credential.setUsernametoken(token);
            RequestData data = new RequestData();
            data.setMsgContext((Object)message);
            credential = this.validator.validate(credential, data);
            SecurityContext sc = null;
            if (credential != null && credential.getPrincipal() != null) {
                sc = this.createSecurityContext(message, credential);
            } else {
                WSUsernameTokenPrincipalImpl p = new WSUsernameTokenPrincipalImpl(policy.getUserName(), false);
                p.setPassword(policy.getPassword());
                sc = this.createSecurityContext((Principal)p);
            }
            message.put(SecurityContext.class, (Object)sc);
        }
        catch (Exception ex) {
            throw new Fault((Throwable)ex);
        }
    }

    protected UsernameToken convertPolicyToToken(AuthorizationPolicy policy) throws Exception {
        Document doc = DOMUtils.createDocument();
        UsernameToken token = new UsernameToken(false, doc, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        token.setName(policy.getUserName());
        token.setPassword(policy.getPassword());
        return token;
    }

    protected SecurityContext createSecurityContext(final Principal p) {
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return p;
            }

            public boolean isUserInRole(String arg0) {
                return false;
            }
        };
    }

    protected SecurityContext createSecurityContext(Message msg, Credential credential) {
        SamlAssertionWrapper samlAssertion = credential.getTransformedToken();
        if (samlAssertion == null) {
            samlAssertion = credential.getSamlAssertion();
        }
        if (samlAssertion != null) {
            String roleAttributeName = (String)SecurityUtils.getSecurityPropertyValue((String)"security.saml-role-attributename", (Message)msg);
            if (roleAttributeName == null || roleAttributeName.length() == 0) {
                roleAttributeName = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";
            }
            ClaimCollection claims = SAMLUtils.getClaims((SamlAssertionWrapper)samlAssertion);
            Set roles = SAMLUtils.parseRolesFromClaims((ClaimCollection)claims, (String)roleAttributeName, null);
            SAMLSecurityContext context = new SAMLSecurityContext(credential.getPrincipal(), roles, claims);
            context.setIssuer(SAMLUtils.getIssuer((Object)samlAssertion));
            context.setAssertionElement(SAMLUtils.getAssertionElement((Object)samlAssertion));
            return context;
        }
        return this.createSecurityContext(credential.getPrincipal());
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

