/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

abstract class AbstractKeyManagerService
implements Service<KeyManager[]> {
    private volatile char[] keystorePassword;
    private volatile char[] keyPassword;
    private volatile KeyManager[] theKeyManagers;

    AbstractKeyManagerService(char[] keystorePassword, char[] keyPassword) {
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
    }

    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.theKeyManagers = this.createKeyManagers();
        }
        catch (UnrecoverableKeyException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        catch (KeyStoreException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
    }

    public void stop(StopContext context) {
        this.theKeyManagers = null;
    }

    public KeyManager[] getValue() throws IllegalStateException, IllegalArgumentException {
        return this.theKeyManagers;
    }

    protected KeyManager[] createKeyManagers() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyStore keyStore = this.loadKeyStore();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, this.keyPassword == null ? this.keystorePassword : this.keyPassword);
        return keyManagerFactory.getKeyManagers();
    }

    protected abstract KeyStore loadKeyStore();

    static final class ServiceUtil {
        private static final String SERVICE_SUFFIX = "key-manager";

        ServiceUtil() {
        }

        public static ServiceName createServiceName(ServiceName parentService) {
            return parentService.append(new String[]{SERVICE_SUFFIX});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<KeyManager[]> injector, ServiceName parentService) {
            sb.addDependency(ServiceUtil.createServiceName(parentService), KeyManager[].class, injector);
            return sb;
        }
    }
}

