/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.HibernateException;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AbstractOptimizer;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class PooledLoThreadLocalOptimizer
extends AbstractOptimizer {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)PooledLoThreadLocalOptimizer.class.getName());
    private GenerationState noTenantState;
    private Map<String, GenerationState> tenantSpecificState;
    private final ThreadLocal<GenerationState> localAssignedIds = new ThreadLocal();

    public PooledLoThreadLocalOptimizer(Class returnClass, int incrementSize) {
        super(returnClass, incrementSize);
        if (incrementSize < 1) {
            throw new HibernateException("increment size cannot be less than 1");
        }
        LOG.creatingPooledLoOptimizer(incrementSize, returnClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable generate(AccessCallback callback) {
        GenerationState local = null;
        if (callback.getTenantIdentifier() == null) {
            local = this.localAssignedIds.get();
        } else if (this.tenantSpecificState != null) {
            local = this.tenantSpecificState.get(callback.getTenantIdentifier());
        }
        if (local != null && local.value.lt(local.upperLimitValue)) {
            return local.value.makeValueThenIncrement();
        }
        PooledLoThreadLocalOptimizer pooledLoThreadLocalOptimizer = this;
        synchronized (pooledLoThreadLocalOptimizer) {
            GenerationState generationState = this.locateGenerationState(callback);
            if (callback.getTenantIdentifier() != null) {
                return generationState.value.makeValueThenIncrement();
            }
            if (local == null) {
                this.localAssignedIds.set(generationState);
            }
            if (!generationState.value.lt(generationState.upperLimitValue)) {
                generationState.lastSourceValue = callback.getNextValue();
                generationState.upperLimitValue = generationState.lastSourceValue.copy().add(this.incrementSize);
                generationState.value = generationState.lastSourceValue.copy();
                while (generationState.value.lt(1L)) {
                    generationState.value.increment();
                }
            }
            return generationState.value.makeValueThenIncrement();
        }
    }

    private GenerationState locateGenerationState(AccessCallback callback) {
        GenerationState state;
        if (callback.getTenantIdentifier() == null) {
            if (this.noTenantState == null) {
                this.noTenantState = new GenerationState(callback, this.incrementSize);
            }
            return this.noTenantState;
        }
        if (this.tenantSpecificState == null) {
            this.tenantSpecificState = new ConcurrentHashMap<String, GenerationState>();
            state = new GenerationState(callback, this.incrementSize);
            this.tenantSpecificState.put(callback.getTenantIdentifier(), state);
        } else {
            state = this.tenantSpecificState.get(callback.getTenantIdentifier());
            if (state == null) {
                state = new GenerationState(callback, this.incrementSize);
                this.tenantSpecificState.put(callback.getTenantIdentifier(), state);
            }
        }
        return state;
    }

    private GenerationState noTenantGenerationState() {
        if (this.noTenantState == null) {
            throw new IllegalStateException("Could not locate previous generation state for no-tenant");
        }
        return this.noTenantState;
    }

    @Override
    public IntegralDataTypeHolder getLastSourceValue() {
        return this.noTenantGenerationState().lastSourceValue;
    }

    @Override
    public boolean applyIncrementSizeToSourceValues() {
        return true;
    }

    private static class GenerationState {
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder value;
        private IntegralDataTypeHolder upperLimitValue;

        private GenerationState(AccessCallback callback, int incrementSize) {
            this.lastSourceValue = callback.getNextValue();
            this.upperLimitValue = this.lastSourceValue.copy().add(incrementSize);
            this.value = this.lastSourceValue.copy();
        }
    }
}

