/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;

public class ConfigurationManager {
    private final GlobalConfiguration globalConfiguration;
    private final Configuration defaultConfiguration;
    private final ConcurrentMap<String, Configuration> namedConfiguration;

    public ConfigurationManager(ConfigurationBuilderHolder globalConfigurationHolder, ConfigurationBuilderHolder defaultConfigurationHolder, Optional<ConfigurationBuilderHolder> namedConfigurationHolder) {
        this.globalConfiguration = globalConfigurationHolder.getGlobalConfigurationBuilder().build();
        this.defaultConfiguration = defaultConfigurationHolder.getDefaultConfigurationBuilder().build(this.globalConfiguration);
        this.namedConfiguration = CollectionFactory.makeConcurrentMap();
        if (namedConfigurationHolder.isPresent()) {
            for (Map.Entry<String, ConfigurationBuilder> entry : namedConfigurationHolder.get().getNamedConfigurationBuilders().entrySet()) {
                ConfigurationBuilder builder = entry.getValue();
                Configuration c = builder.build(this.globalConfiguration);
                this.namedConfiguration.put(entry.getKey(), c);
            }
        }
    }

    public ConfigurationManager(ConfigurationBuilderHolder holder) {
        this(holder, holder, Optional.of(holder));
    }

    public ConfigurationManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration) {
        this.globalConfiguration = globalConfiguration;
        this.defaultConfiguration = defaultConfiguration;
        this.namedConfiguration = CollectionFactory.makeConcurrentMap();
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public Configuration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public Configuration getConfiguration(String cacheName) {
        return "___defaultcache".equals(cacheName) ? this.defaultConfiguration : (Configuration)this.namedConfiguration.get(cacheName);
    }

    public Configuration getConfigurationOrDefault(String cacheName) {
        if ("___defaultcache".equals(cacheName) || !this.namedConfiguration.containsKey(cacheName)) {
            return new ConfigurationBuilder().read(this.defaultConfiguration).build(this.globalConfiguration);
        }
        return (Configuration)this.namedConfiguration.get(cacheName);
    }

    public Configuration putConfiguration(String cacheName, ConfigurationBuilder builder) {
        Configuration configuration = builder.build(this.globalConfiguration);
        this.namedConfiguration.put(cacheName, configuration);
        return configuration;
    }

    public void removeConfiguration(String cacheName) {
        this.namedConfiguration.remove(cacheName);
    }

    public Collection<String> getDefinedCaches() {
        return Collections.unmodifiableCollection(this.namedConfiguration.keySet());
    }
}

