/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.threads.BoundedQueueThreadPoolAdd;
import org.jboss.as.threads.BoundedQueueThreadPoolMetricsHandler;
import org.jboss.as.threads.BoundedQueueThreadPoolRemove;
import org.jboss.as.threads.BoundedQueueThreadPoolWriteAttributeHandler;
import org.jboss.as.threads.HandoffExecutorResolver;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadPoolResourceDescriptionResolver;
import org.jboss.as.threads.ThreadsExtension;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.msc.service.ServiceName;

public class BoundedQueueThreadPoolResourceDefinition
extends PersistentResourceDefinition {
    public static final BoundedQueueThreadPoolResourceDefinition BLOCKING = BoundedQueueThreadPoolResourceDefinition.create(true, false);
    public static final BoundedQueueThreadPoolResourceDefinition NON_BLOCKING = BoundedQueueThreadPoolResourceDefinition.create(false, false);
    private final BoundedQueueThreadPoolMetricsHandler metricsHandler;
    private final BoundedQueueThreadPoolWriteAttributeHandler writeHandler;
    private final boolean blocking;
    private final boolean registerRuntimeOnly;

    public static BoundedQueueThreadPoolResourceDefinition create(boolean blocking, boolean registerRuntimeOnly) {
        if (blocking) {
            return BoundedQueueThreadPoolResourceDefinition.create("blocking-bounded-queue-thread-pool", ThreadsServices.STANDARD_THREAD_FACTORY_RESOLVER, null, ThreadsServices.EXECUTOR, registerRuntimeOnly);
        }
        return BoundedQueueThreadPoolResourceDefinition.create("bounded-queue-thread-pool", ThreadsServices.STANDARD_THREAD_FACTORY_RESOLVER, ThreadsServices.STANDARD_HANDOFF_EXECUTOR_RESOLVER, ThreadsServices.EXECUTOR, registerRuntimeOnly);
    }

    public static BoundedQueueThreadPoolResourceDefinition create(boolean blocking, String type, boolean registerRuntimeOnly) {
        if (blocking) {
            return BoundedQueueThreadPoolResourceDefinition.create(type, ThreadsServices.STANDARD_THREAD_FACTORY_RESOLVER, null, ThreadsServices.EXECUTOR, registerRuntimeOnly);
        }
        return BoundedQueueThreadPoolResourceDefinition.create(type, ThreadsServices.STANDARD_THREAD_FACTORY_RESOLVER, ThreadsServices.STANDARD_HANDOFF_EXECUTOR_RESOLVER, ThreadsServices.EXECUTOR, registerRuntimeOnly);
    }

    public static BoundedQueueThreadPoolResourceDefinition create(String type, ThreadFactoryResolver threadFactoryResolver, HandoffExecutorResolver handoffExecutorResolver, ServiceName poolNameBase, boolean registerRuntimeOnly) {
        boolean blocking = handoffExecutorResolver == null;
        String resolverPrefix = blocking ? "blocking-bounded-queue-thread-pool" : "bounded-queue-thread-pool";
        BoundedQueueThreadPoolAdd addHandler = new BoundedQueueThreadPoolAdd(blocking, threadFactoryResolver, handoffExecutorResolver, poolNameBase);
        BoundedQueueThreadPoolRemove removeHandler = new BoundedQueueThreadPoolRemove(addHandler);
        return new BoundedQueueThreadPoolResourceDefinition(blocking, registerRuntimeOnly, type, poolNameBase, resolverPrefix, (OperationStepHandler)addHandler, (OperationStepHandler)removeHandler);
    }

    private BoundedQueueThreadPoolResourceDefinition(boolean blocking, boolean registerRuntimeOnly, String type, ServiceName serviceNameBase, String resolverPrefix, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(PathElement.pathElement((String)type), (ResourceDescriptionResolver)new ThreadPoolResourceDescriptionResolver(resolverPrefix, ThreadsExtension.RESOURCE_NAME, ThreadsExtension.class.getClassLoader()), addHandler, removeHandler);
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.blocking = blocking;
        this.metricsHandler = new BoundedQueueThreadPoolMetricsHandler(serviceNameBase);
        this.writeHandler = new BoundedQueueThreadPoolWriteAttributeHandler(blocking, serviceNameBase);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PoolAttributeDefinitions.NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
        this.writeHandler.registerAttributes(resourceRegistration);
        if (this.registerRuntimeOnly) {
            this.metricsHandler.registerAttributes(resourceRegistration);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(this.writeHandler.attributes);
    }

    public boolean isBlocking() {
        return this.blocking;
    }
}

