/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms.management;

import org.apache.activemq.artemis.utils.json.JSONArray;
import org.apache.activemq.artemis.utils.json.JSONException;
import org.apache.activemq.artemis.utils.json.JSONObject;

public class JMSSessionInfo {
    private final String sessionID;
    private final long creationTime;

    public JMSSessionInfo(String sessionID, long creationTime) {
        this.sessionID = sessionID;
        this.creationTime = creationTime;
    }

    public static JMSSessionInfo[] from(String jsonString) throws JSONException {
        JSONArray array = new JSONArray(jsonString);
        JMSSessionInfo[] infos = new JMSSessionInfo[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            JMSSessionInfo info;
            JSONObject obj = array.getJSONObject(i);
            infos[i] = info = new JMSSessionInfo(obj.getString("sessionID"), obj.getLong("creationTime"));
        }
        return infos;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }
}

