/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.util;

public final class LDAPUtil {
    public static String convertObjectGUIToByteString(byte[] objectGUID) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < objectGUID.length; ++i) {
            String transformed = LDAPUtil.prefixZeros(objectGUID[i] & 0xFF);
            result.append("\\");
            result.append(transformed);
        }
        return result.toString();
    }

    public static String decodeObjectGUID(byte[] objectGUID) {
        StringBuilder displayStr = new StringBuilder();
        displayStr.append(LDAPUtil.convertToDashedString(objectGUID));
        return displayStr.toString();
    }

    private static String convertToDashedString(byte[] objectGUID) {
        StringBuilder displayStr = new StringBuilder();
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[3] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[2] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[1] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[0] & 0xFF));
        displayStr.append("-");
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[5] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[4] & 0xFF));
        displayStr.append("-");
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[7] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[6] & 0xFF));
        displayStr.append("-");
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[8] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[9] & 0xFF));
        displayStr.append("-");
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[10] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[11] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[12] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[13] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[14] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[15] & 0xFF));
        return displayStr.toString();
    }

    private static String prefixZeros(int value) {
        if (value <= 15) {
            StringBuilder sb = new StringBuilder("0");
            sb.append(Integer.toHexString(value));
            return sb.toString();
        }
        return Integer.toHexString(value);
    }
}

