/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.util;

import com.arjuna.webservices11.util.ServiceAction;
import java.security.AccessController;
import javax.xml.ws.Service;

public class PrivilegedServiceFactory<T extends Service> {
    private final Class<T> serviceClass;

    public PrivilegedServiceFactory(Class<T> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public static <T extends Service> PrivilegedServiceFactory<T> getInstance(Class<T> serviceClass) {
        return new PrivilegedServiceFactory<T>(serviceClass);
    }

    public T getService() {
        ServiceAction<T> serviceAction = ServiceAction.getInstance(this.serviceClass);
        if (System.getSecurityManager() == null) {
            return serviceAction.run();
        }
        return (T)((Service)AccessController.doPrivileged(serviceAction));
    }
}

