/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.jboss.as.domain.management.security.PropertiesFileLoader;

public class UserPropertiesFileLoader
extends PropertiesFileLoader {
    private static final String REALM_COMMENT_PREFIX = "$REALM_NAME=";
    private static final String REALM_COMMENT_SUFFIX = "$";
    private static final String REALM_COMMENT_COMMENT = " This line is used by the add-user utility to identify the realm name already used in this file.";
    private String realmName;
    private List<String> enabledUserNames = new ArrayList<String>();
    private List<String> disabledUserNames = new ArrayList<String>();
    private boolean realmWritten = false;

    public UserPropertiesFileLoader(String path, String relativeTo) {
        super(path, relativeTo);
    }

    public String getRealmName() throws IOException {
        this.loadAsRequired();
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public List<String> getUserNames() throws IOException {
        this.loadAsRequired();
        ArrayList<String> userNames = new ArrayList<String>();
        userNames.addAll(this.enabledUserNames);
        userNames.addAll(this.disabledUserNames);
        return userNames;
    }

    public List<String> getEnabledUserNames() throws IOException {
        this.loadAsRequired();
        return this.enabledUserNames;
    }

    public List<String> getDisabledUserNames() throws IOException {
        this.loadAsRequired();
        return this.disabledUserNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load() throws IOException {
        super.load();
        String realmName = null;
        BufferedReader br = new BufferedReader(new FileReader(this.propertiesFile));
        this.disabledUserNames.clear();
        this.enabledUserNames.clear();
        try {
            String currentLine;
            while (realmName == null && (currentLine = br.readLine()) != null) {
                int start;
                int end;
                String trimmed = currentLine.trim();
                Matcher matcher = PROPERTY_PATTERN.matcher(currentLine.trim());
                if (matcher.matches()) {
                    String username = this.cleanKey(matcher.group(1));
                    if (trimmed.startsWith("#")) {
                        this.disabledUserNames.add(username);
                    } else {
                        this.enabledUserNames.add(username);
                    }
                }
                if (!trimmed.startsWith("#") || !trimmed.contains(REALM_COMMENT_PREFIX) || (end = trimmed.indexOf(REALM_COMMENT_SUFFIX, start = trimmed.indexOf(REALM_COMMENT_PREFIX) + REALM_COMMENT_PREFIX.length())) <= -1) continue;
                realmName = trimmed.substring(start, end);
            }
        }
        finally {
            this.safeClose(br);
        }
        this.realmName = realmName;
    }

    @Override
    protected void beginPersistence() throws IOException {
        super.beginPersistence();
        this.realmWritten = false;
    }

    @Override
    protected void write(BufferedWriter writer, String line, boolean newLine) throws IOException {
        String trimmed;
        if (!this.realmWritten && (trimmed = line.trim()).startsWith("#") && trimmed.contains(REALM_COMMENT_PREFIX)) {
            this.realmWritten = true;
        }
        super.write(writer, line, newLine);
    }

    @Override
    protected void endPersistence(BufferedWriter writer) throws IOException {
        super.endPersistence(writer);
        if (!this.realmWritten) {
            this.writeRealm(writer, this.realmName);
        }
    }

    @Override
    protected void addLineContent(BufferedReader bufferedFileReader, List<String> content, String line) throws IOException {
        if (line.startsWith("#") && line.length() == 1) {
            String nextLine = bufferedFileReader.readLine();
            if (nextLine != null) {
                if (nextLine.startsWith("#") && nextLine.contains(REALM_COMMENT_PREFIX)) {
                    bufferedFileReader.readLine();
                } else {
                    content.add(line);
                    content.add(nextLine);
                }
            } else {
                super.addLineContent(bufferedFileReader, content, line);
            }
        } else {
            super.addLineContent(bufferedFileReader, content, line);
        }
    }

    private void writeRealm(BufferedWriter bw, String realmName) throws IOException {
        bw.append("#");
        bw.newLine();
        bw.append("#");
        bw.append(REALM_COMMENT_PREFIX);
        bw.append(realmName);
        bw.append(REALM_COMMENT_SUFFIX);
        bw.append(REALM_COMMENT_COMMENT);
        bw.newLine();
        bw.append("#");
        bw.newLine();
    }
}

