/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.AbstractIdentityConfigurationChildBuilder;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.config.FileStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfigurationChildBuilder;
import org.picketlink.idm.config.JDBCIdentityStoreConfiguration;
import org.picketlink.idm.config.JDBCStoreConfigurationBuilder;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.config.NamedIdentityConfigurationBuilder;
import org.picketlink.idm.config.TokenStoreConfiguration;
import org.picketlink.idm.config.TokenStoreConfigurationBuilder;
import org.picketlink.idm.config.annotation.MethodConfigID;
import org.picketlink.idm.config.annotation.ParameterConfigID;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Relationship;

public class IdentityStoresConfigurationBuilder
extends AbstractIdentityConfigurationChildBuilder<List<? extends IdentityStoreConfiguration>>
implements IdentityStoreConfigurationChildBuilder {
    private final List<IdentityStoreConfigurationBuilder<?, ?>> identityStoresConfiguration = new ArrayList();
    private final Map<Class<? extends IdentityStoreConfiguration>, Class<? extends IdentityStoreConfigurationBuilder<?, ?>>> supportedStoreBuilders = new HashMap();
    private final Set<Class<? extends Relationship>> globalRelationships = new HashSet<Class<? extends Relationship>>();
    private final Set<Class<? extends Relationship>> selfRelationships = new HashSet<Class<? extends Relationship>>();

    protected IdentityStoresConfigurationBuilder(NamedIdentityConfigurationBuilder builder) {
        super(builder);
        this.supportedStoreBuilders.put(FileIdentityStoreConfiguration.class, FileStoreConfigurationBuilder.class);
        this.supportedStoreBuilders.put(JPAIdentityStoreConfiguration.class, JPAStoreConfigurationBuilder.class);
        this.supportedStoreBuilders.put(LDAPIdentityStoreConfiguration.class, LDAPStoreConfigurationBuilder.class);
        this.supportedStoreBuilders.put(JDBCIdentityStoreConfiguration.class, JDBCStoreConfigurationBuilder.class);
        this.supportedStoreBuilders.put(TokenStoreConfiguration.class, TokenStoreConfigurationBuilder.class);
    }

    @Override
    public FileStoreConfigurationBuilder file() {
        return (FileStoreConfigurationBuilder)this.forIdentityStoreConfig(FileIdentityStoreConfiguration.class, true);
    }

    public JDBCStoreConfigurationBuilder jdbc() {
        return (JDBCStoreConfigurationBuilder)this.forIdentityStoreConfig(JDBCIdentityStoreConfiguration.class, true);
    }

    @Override
    public JPAStoreConfigurationBuilder jpa() {
        return (JPAStoreConfigurationBuilder)this.forIdentityStoreConfig(JPAIdentityStoreConfiguration.class, true);
    }

    @Override
    public LDAPStoreConfigurationBuilder ldap() {
        return (LDAPStoreConfigurationBuilder)this.forIdentityStoreConfig(LDAPIdentityStoreConfiguration.class, true);
    }

    @Override
    public TokenStoreConfigurationBuilder token() {
        return (TokenStoreConfigurationBuilder)this.forIdentityStoreConfig(TokenStoreConfiguration.class, true);
    }

    @Override
    @MethodConfigID(name="customIdentityStore")
    public <T extends IdentityStoreConfigurationBuilder<?, ?>> T add(@ParameterConfigID(name="identityStoreConfigurationClass") Class<? extends IdentityStoreConfiguration> identityStoreConfiguration, @ParameterConfigID(name="builderClass") Class<T> builder) {
        this.supportedStoreBuilders.put(identityStoreConfiguration, builder);
        return (T)this.forIdentityStoreConfig(identityStoreConfiguration, true);
    }

    public List<IdentityStoreConfigurationBuilder<?, ?>> getIdentityStoresConfigurationBuilder() {
        return this.identityStoresConfiguration;
    }

    @Override
    protected List<? extends IdentityStoreConfiguration> create() {
        ArrayList<IdentityStoreConfiguration> configurations = new ArrayList<IdentityStoreConfiguration>();
        IdentityStoreConfiguration partitionStoreConfig = null;
        for (IdentityStoreConfigurationBuilder<?, ?> storeConfigurationBuilder : this.identityStoresConfiguration) {
            IdentityStoreConfiguration storeConfiguration = (IdentityStoreConfiguration)storeConfigurationBuilder.create();
            if (storeConfiguration.supportsPartition()) {
                if (partitionStoreConfig != null) {
                    throw IDMMessages.MESSAGES.configStoreMultiplePartitionConfigExists(partitionStoreConfig, storeConfiguration);
                }
                partitionStoreConfig = storeConfiguration;
            }
            for (Class<Relationship> relType : storeConfigurationBuilder.getGlobalRelationshipTypes()) {
                this.globalRelationships.add(relType);
            }
            for (Class<Relationship> relType : storeConfigurationBuilder.getSelfRelationshipTypes()) {
                this.selfRelationships.add(relType);
            }
            configurations.add(storeConfiguration);
        }
        return configurations;
    }

    @Override
    protected void validate() {
        if (this.identityStoresConfiguration.isEmpty()) {
            throw IDMMessages.MESSAGES.configStoreNoIdentityStoreConfigProvided();
        }
        for (IdentityStoreConfigurationBuilder<?, ?> currentConfiguration : this.identityStoresConfiguration) {
            currentConfiguration.validate();
            for (Class<AttributedType> type : currentConfiguration.getSupportedTypes().keySet()) {
                for (IdentityStoreConfigurationBuilder<?, ?> storeConfiguration : this.identityStoresConfiguration) {
                    if (storeConfiguration.equals(currentConfiguration)) continue;
                    for (Class<AttributedType> storeType : storeConfiguration.getSupportedTypes().keySet()) {
                        if (!storeType.isAssignableFrom(type)) continue;
                        throw IDMMessages.MESSAGES.configStoreDuplicatedSupportedType(type);
                    }
                }
            }
        }
    }

    protected IdentityStoresConfigurationBuilder readFrom(List<? extends IdentityStoreConfiguration> fromConfiguration) {
        if (fromConfiguration == null) {
            throw IDMMessages.MESSAGES.nullArgument("Configurations to read");
        }
        for (IdentityStoreConfiguration identityStoreConfiguration : fromConfiguration) {
            Object storeConfigBuilder = this.forIdentityStoreConfig(identityStoreConfiguration.getClass(), true);
            ((IdentityStoreConfigurationBuilder)storeConfigBuilder).readFrom((IdentityStoreConfiguration)identityStoreConfiguration);
        }
        return this;
    }

    private <S extends IdentityStoreConfigurationBuilder<?, ?>> S forIdentityStoreConfig(Class<? extends IdentityStoreConfiguration> configurationType, boolean createIfNotExists) {
        IdentityStoreConfigurationBuilder<?, ?> instance;
        Class<IdentityStoreConfigurationBuilder<?, ?>> builderType = this.supportedStoreBuilders.get(configurationType);
        for (IdentityStoreConfigurationBuilder<?, ?> registeredStoreConfig : this.identityStoresConfiguration) {
            if (!registeredStoreConfig.getClass().equals(builderType)) continue;
            return (S)registeredStoreConfig;
        }
        if (!createIfNotExists) {
            return null;
        }
        try {
            instance = builderType.getConstructor(IdentityStoresConfigurationBuilder.class).newInstance(this);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.instantiationError(builderType, e);
        }
        this.identityStoresConfiguration.add(instance);
        return (S)instance;
    }

    protected Set<Class<? extends Relationship>> getGlobalRelationships() {
        return this.globalRelationships;
    }

    protected Set<Class<? extends Relationship>> getSelfRelationships() {
        return this.selfRelationships;
    }
}

