/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.freemarker.beans;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.freemarker.beans.MessageBean;
import org.keycloak.freemarker.beans.MessageType;

public class MessagesPerFieldBean {
    private Map<String, MessageBean> messagesPerField = new HashMap<String, MessageBean>();

    public void addMessage(String field, String messageText, MessageType messageType) {
        MessageBean fm;
        if (messageText == null || messageText.trim().isEmpty()) {
            return;
        }
        if (field == null) {
            field = "global";
        }
        if ((fm = this.messagesPerField.get(field)) == null) {
            this.messagesPerField.put(field, new MessageBean(messageText, messageType));
        } else {
            fm.appendSummaryLine(messageText);
        }
    }

    public boolean exists(String field) {
        return this.messagesPerField.containsKey(field);
    }

    public String get(String fieldName) {
        MessageBean mb = this.messagesPerField.get(fieldName);
        if (mb != null) {
            return mb.getSummary();
        }
        return "";
    }

    public String printIfExists(String fieldName, String text) {
        if (this.exists(fieldName)) {
            return text;
        }
        return "";
    }
}

