/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.compat;

import java.util.Iterator;
import java.util.Spliterator;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.compat.TypeConverter;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.stream.impl.AbstractDelegatingCacheStream;
import org.infinispan.stream.impl.spliterators.IteratorAsSpliterator;

public class TypeConverterStream
extends AbstractDelegatingCacheStream {
    private final TypeConverter<Object, Object, Object, Object> converter;
    private final InternalEntryFactory entryFactory;

    public TypeConverterStream(CacheStream<?> stream, TypeConverter<Object, Object, Object, Object> converter, InternalEntryFactory entryFactory) {
        super(stream);
        this.converter = converter;
        this.entryFactory = entryFactory;
    }

    @Override
    public Iterator<Object> iterator() {
        return new IteratorMapper(super.iterator(), e -> {
            if (e instanceof CacheEntry) {
                return TypeConverterStream.convert((CacheEntry)e, this.converter, this.entryFactory);
            }
            return this.converter.unboxValue(e);
        });
    }

    @Override
    public Spliterator<Object> spliterator() {
        return new IteratorAsSpliterator.Builder<Object>(this.iterator()).setEstimateRemaining(super.spliterator().estimateSize()).setCharacteristics(4353).get();
    }

    private static <K, V> CacheEntry<K, V> convert(CacheEntry<K, V> entry, TypeConverter<Object, Object, Object, Object> converter, InternalEntryFactory entryFactory) {
        Object newKey = converter.unboxKey(entry.getKey());
        Object newValue = converter.unboxValue(entry.getValue());
        if (newKey != entry.getKey() || newValue != entry.getValue()) {
            return entryFactory.create(newKey, newValue, entry.getMetadata());
        }
        return entry;
    }
}

