/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Set;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.topology.CacheTopologyControlCommand;

public class ReplicableCommandExternalizer
extends AbstractExternalizer<ReplicableCommand> {
    private final RemoteCommandsFactory cmdFactory;
    private final GlobalComponentRegistry globalComponentRegistry;

    public ReplicableCommandExternalizer(RemoteCommandsFactory cmdFactory, GlobalComponentRegistry globalComponentRegistry) {
        this.cmdFactory = cmdFactory;
        this.globalComponentRegistry = globalComponentRegistry;
    }

    public void writeObject(ObjectOutput output, ReplicableCommand command) throws IOException {
        this.writeCommandHeader(output, command);
        this.writeCommandParameters(output, command);
    }

    protected void writeCommandParameters(ObjectOutput output, ReplicableCommand command) throws IOException {
        Object[] args = command.getParameters();
        int numArgs = args == null ? 0 : args.length;
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)numArgs);
        for (int i = 0; i < numArgs; ++i) {
            Object arg = args[i];
            if (arg instanceof DeltaAware) {
                DeltaAware dw = (DeltaAware)arg;
                output.writeObject(dw.delta());
                continue;
            }
            output.writeObject(arg);
        }
        if (command instanceof TopologyAffectedCommand) {
            output.writeInt(((TopologyAffectedCommand)command).getTopologyId());
        }
    }

    protected void writeCommandHeader(ObjectOutput output, ReplicableCommand command) throws IOException {
        Collection<Class<? extends ReplicableCommand>> moduleCommands = this.getModuleCommands();
        if (moduleCommands != null && moduleCommands.contains(command.getClass())) {
            output.writeByte(1);
        } else {
            output.writeByte(0);
        }
        output.writeShort(command.getCommandId());
    }

    public ReplicableCommand readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object[] args;
        byte type = input.readByte();
        short methodId = input.readShort();
        ReplicableCommand replicableCommand = this.cmdFactory.fromStream((byte)methodId, args = this.readParameters(input), type);
        if (replicableCommand instanceof TopologyAffectedCommand) {
            int topologyId = input.readInt();
            ((TopologyAffectedCommand)replicableCommand).setTopologyId(topologyId);
        }
        return replicableCommand;
    }

    protected Object[] readParameters(ObjectInput input) throws IOException, ClassNotFoundException {
        int numArgs = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        Object[] args = null;
        if (numArgs > 0) {
            args = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                args[i] = input.readObject();
            }
        }
        return args;
    }

    protected CacheRpcCommand fromStream(byte id, Object[] parameters, byte type, String cacheName) {
        return this.cmdFactory.fromStream(id, parameters, type, cacheName);
    }

    public Integer getId() {
        return 62;
    }

    public Set<Class<? extends ReplicableCommand>> getTypeClasses() {
        Set coreCommands = Util.asSet((Object[])new Class[]{CacheTopologyControlCommand.class, DistributedExecuteCommand.class, GetKeyValueCommand.class, ClearCommand.class, EvictCommand.class, ApplyDeltaCommand.class, InvalidateCommand.class, InvalidateL1Command.class, PutKeyValueCommand.class, PutMapCommand.class, RemoveCommand.class, RemoveExpiredCommand.class, ReplaceCommand.class, GetKeysInGroupCommand.class, ReadWriteKeyCommand.class, ReadWriteKeyValueCommand.class, WriteOnlyKeyCommand.class, WriteOnlyKeyValueCommand.class, WriteOnlyManyCommand.class, WriteOnlyManyEntriesCommand.class, ReadWriteManyCommand.class, ReadWriteManyEntriesCommand.class});
        Collection<Class<? extends ReplicableCommand>> moduleCommands = this.globalComponentRegistry.getModuleProperties().moduleOnlyReplicableCommands();
        if (moduleCommands != null && !moduleCommands.isEmpty()) {
            coreCommands.addAll(moduleCommands);
        }
        return coreCommands;
    }

    private Collection<Class<? extends ReplicableCommand>> getModuleCommands() {
        return this.globalComponentRegistry.getModuleProperties().moduleCommands();
    }
}

