/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.mod_cluster.CustomLoadMetricDefinition;
import org.wildfly.extension.mod_cluster.DynamicLoadProviderDefinition;
import org.wildfly.extension.mod_cluster.Element;
import org.wildfly.extension.mod_cluster.LoadMetricDefinition;
import org.wildfly.extension.mod_cluster.ModClusterConfigResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterSSLResourceDefinition;
import org.wildfly.extension.mod_cluster.Namespace;

public class ModClusterSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode node = context.getModelNode();
        if (node.get(ModClusterConfigResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
            ModClusterSubsystemXMLWriter.writeModClusterConfig(writer, node.get(ModClusterConfigResourceDefinition.PATH.getKeyValuePair()));
        } else {
            ModClusterSubsystemXMLWriter.writeModClusterConfig(writer, node);
        }
        writer.writeEndElement();
    }

    static void writeModClusterConfig(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.MOD_CLUSTER_CONFIG.getLocalName());
        ModClusterSubsystemXMLWriter.writeConfiguration(writer, config);
        if (config.hasDefined("simple-load-provider")) {
            ModClusterSubsystemXMLWriter.writeSimpleLoadProvider(writer, config);
        }
        if (config.get(DynamicLoadProviderDefinition.PATH.getKeyValuePair()).isDefined()) {
            ModClusterSubsystemXMLWriter.writeDynamicLoadProvider(writer, config.get(DynamicLoadProviderDefinition.PATH.getKeyValuePair()));
        }
        if (config.get(ModClusterSSLResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
            ModClusterSubsystemXMLWriter.writeSSL(writer, config.get(ModClusterSSLResourceDefinition.PATH.getKeyValuePair()));
        }
        writer.writeEndElement();
    }

    static void writeConfiguration(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        for (AttributeDefinition def : ModClusterConfigResourceDefinition.ATTRIBUTES) {
            def.getAttributeMarshaller().marshallAsAttribute(def, config, true, (XMLStreamWriter)writer);
        }
    }

    static void writeSSL(XMLExtendedStreamWriter writer, ModelNode sslConfig) throws XMLStreamException {
        writer.writeStartElement(Element.SSL.getLocalName());
        for (SimpleAttributeDefinition def : ModClusterSSLResourceDefinition.ATTRIBUTES) {
            def.marshallAsAttribute(sslConfig, false, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    static void writeSimpleLoadProvider(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.SIMPLE_LOAD_PROVIDER.getLocalName());
        ModClusterConfigResourceDefinition.SIMPLE_LOAD_PROVIDER.marshallAsAttribute(config, false, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    static void writeDynamicLoadProvider(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.DYNAMIC_LOAD_PROVIDER.getLocalName());
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "history", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "decay", config);
        if (config.hasDefined("load-metric")) {
            ModClusterSubsystemXMLWriter.writeLoadMetric(writer, config.get("load-metric"));
        }
        if (config.hasDefined("custom-load-metric")) {
            ModClusterSubsystemXMLWriter.writeCustomLoadMetric(writer, config.get("custom-load-metric"));
        }
        writer.writeEndElement();
    }

    static void writeLoadMetric(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        for (Property prop : config.asPropertyList()) {
            ModelNode node = prop.getValue();
            writer.writeStartElement(Element.LOAD_METRIC.getLocalName());
            LoadMetricDefinition.TYPE.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            LoadMetricDefinition.WEIGHT.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            LoadMetricDefinition.CAPACITY.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            if (node.get("property").isDefined()) {
                for (Property property : node.get("property").asPropertyList()) {
                    ModClusterSubsystemXMLWriter.writeProperty(writer, property);
                }
            }
            writer.writeEndElement();
        }
    }

    static void writeCustomLoadMetric(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        for (Property prop : config.asPropertyList()) {
            ModelNode node = prop.getValue();
            writer.writeStartElement(Element.CUSTOM_LOAD_METRIC.getLocalName());
            CustomLoadMetricDefinition.CLASS.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            LoadMetricDefinition.WEIGHT.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            LoadMetricDefinition.CAPACITY.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
            if (node.get("property").isDefined()) {
                for (Property property : node.get("property").asPropertyList()) {
                    ModClusterSubsystemXMLWriter.writeProperty(writer, property);
                }
            }
            writer.writeEndElement();
        }
    }

    static void writeAttribute(XMLExtendedStreamWriter writer, String name, ModelNode node) throws XMLStreamException {
        if (node.hasDefined(name)) {
            writer.writeAttribute(name, node.get(name).asString());
        }
    }

    static void writeProperty(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeStartElement(Element.PROPERTY.getLocalName());
        writer.writeAttribute("name", property.getName());
        writer.writeAttribute("value", property.getValue().asString());
        writer.writeEndElement();
    }
}

