/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.job.repository;

import javax.sql.DataSource;
import org.jberet.repository.JobRepository;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.batch.jberet.BatchResourceDescriptionResolver;
import org.wildfly.extension.batch.jberet._private.Capabilities;
import org.wildfly.extension.batch.jberet.job.repository.JdbcJobRepositoryService;

public class JdbcJobRepositoryDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "jdbc-job-repository";
    static final PathElement PATH = PathElement.pathElement((String)"jdbc-job-repository");
    public static final SimpleAttributeDefinition DATA_SOURCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"data-source", (ModelType)ModelType.STRING, (boolean)false).setCapabilityReference("org.wildfly.data-source", Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), true)).setRestartAllServices()).build();

    public JdbcJobRepositoryDefinition() {
        super(PATH, (ResourceDescriptionResolver)BatchResourceDescriptionResolver.getResourceDescriptionResolver(NAME), (OperationStepHandler)new JdbcRepositoryAddHandler(), (OperationStepHandler)new ReloadRequiredRemoveStepHandler(new RuntimeCapability[]{Capabilities.JOB_REPOSITORY_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DATA_SOURCE, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{DATA_SOURCE}));
    }

    private static class JdbcRepositoryAddHandler
    extends AbstractAddStepHandler {
        JdbcRepositoryAddHandler() {
            super(Capabilities.JOB_REPOSITORY_CAPABILITY, new AttributeDefinition[]{DATA_SOURCE});
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            String name = context.getCurrentAddressValue();
            String dsName = DATA_SOURCE.resolveModelAttribute(context, model).asString();
            ServiceTarget target = context.getServiceTarget();
            JdbcJobRepositoryService service = new JdbcJobRepositoryService();
            Services.addServerExecutorDependency((ServiceBuilder)target.addService(context.getCapabilityServiceName(Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), name, JobRepository.class), (Service)service), service.getExecutorServiceInjector(), (boolean)false).addDependency(context.getCapabilityServiceName("org.wildfly.data-source", dsName, DataSource.class), DataSource.class, service.getDataSourceInjector()).install();
        }
    }
}

