/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import org.wildfly.clustering.marshalling.jboss.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.jboss.MarshalledValue;
import org.wildfly.clustering.marshalling.jboss.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.Marshaller;

public class MarshalledValueMarshaller<V, C>
implements Marshaller<V, MarshalledValue<V, C>, C> {
    private final MarshalledValueFactory<C> factory;
    private final C context;

    public MarshalledValueMarshaller(MarshalledValueFactory<C> factory, C context) {
        this.factory = factory;
        this.context = context;
    }

    @Override
    public V read(MarshalledValue<V, C> value) throws InvalidSerializedFormException {
        if (value == null) {
            return null;
        }
        try {
            return value.get(this.context);
        }
        catch (InvalidClassException | InvalidObjectException | ClassNotFoundException e) {
            throw new InvalidSerializedFormException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public MarshalledValue<V, C> write(V object) {
        if (object == null) {
            return null;
        }
        return this.factory.createMarshalledValue(object);
    }

    @Override
    public C getContext() {
        return this.context;
    }
}

