/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapperFactory;
import org.keycloak.federation.ldap.mappers.HardcodedLDAPRoleMapper;
import org.keycloak.mappers.MapperConfigValidationException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;

public class HardcodedLDAPRoleMapperFactory
extends AbstractLDAPFederationMapperFactory {
    public static final String PROVIDER_ID = "hardcoded-ldap-role-mapper";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getHelpText() {
        return "When user is imported from LDAP, he will be automatically added into this configured role.";
    }

    public String getDisplayCategory() {
        return "Role Mapper";
    }

    public String getDisplayType() {
        return "Hardcoded Role";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public Map<String, String> getDefaultConfig(UserFederationProviderModel providerModel) {
        return new HashMap<String, String>();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void validateConfig(RealmModel realm, UserFederationMapperModel mapperModel) throws MapperConfigValidationException {
        String roleName = (String)mapperModel.getConfig().get("role");
        if (roleName == null) {
            throw new MapperConfigValidationException("Role can't be null");
        }
        RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
        if (role == null) {
            throw new MapperConfigValidationException("There is no role corresponding to configured value");
        }
    }

    @Override
    protected AbstractLDAPFederationMapper createMapper(UserFederationMapperModel mapperModel, LDAPFederationProvider federationProvider, RealmModel realm) {
        return new HardcodedLDAPRoleMapper(mapperModel, federationProvider, realm);
    }

    static {
        ProviderConfigProperty roleAttr = HardcodedLDAPRoleMapperFactory.createConfigProperty("role", "Role", "Role to grant to user.  Click 'Select Role' button to browse roles, or just type it in the textbox.  To reference an application role the syntax is appname.approle, i.e. myapp.myrole", "Role", null);
        configProperties.add(roleAttr);
    }
}

