/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers.membership.group;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.LDAPUtils;
import org.keycloak.federation.ldap.idm.model.LDAPDn;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.membership.CommonLDAPGroupMapper;
import org.keycloak.federation.ldap.mappers.membership.CommonLDAPGroupMapperConfig;
import org.keycloak.federation.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.federation.ldap.mappers.membership.MembershipType;
import org.keycloak.federation.ldap.mappers.membership.UserRolesRetrieveStrategy;
import org.keycloak.federation.ldap.mappers.membership.group.GroupLDAPFederationMapperFactory;
import org.keycloak.federation.ldap.mappers.membership.group.GroupMapperConfig;
import org.keycloak.federation.ldap.mappers.membership.group.GroupTreeResolver;
import org.keycloak.models.GroupModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationSyncResult;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.UserModelDelegate;

public class GroupLDAPFederationMapper
extends AbstractLDAPFederationMapper
implements CommonLDAPGroupMapper {
    private static final Logger logger = Logger.getLogger(GroupLDAPFederationMapper.class);
    private final GroupMapperConfig config;
    private final GroupLDAPFederationMapperFactory factory;
    private boolean syncFromLDAPPerformedInThisTransaction = false;

    public GroupLDAPFederationMapper(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, RealmModel realm, GroupLDAPFederationMapperFactory factory) {
        super(mapperModel, ldapProvider, realm);
        this.config = new GroupMapperConfig(mapperModel);
        this.factory = factory;
    }

    @Override
    public LDAPQuery createLDAPGroupQuery() {
        return this.createGroupQuery();
    }

    @Override
    public CommonLDAPGroupMapperConfig getConfig() {
        return this.config;
    }

    public LDAPQuery createGroupQuery() {
        LDAPQuery ldapQuery = new LDAPQuery(this.ldapProvider);
        ldapQuery.setSearchScope(this.ldapProvider.getLdapIdentityStore().getConfig().getSearchScope());
        String groupsDn = this.config.getGroupsDn();
        ldapQuery.setSearchDn(groupsDn);
        Collection<String> groupObjectClasses = this.config.getGroupObjectClasses(this.ldapProvider);
        ldapQuery.addObjectClasses(groupObjectClasses);
        String customFilter = this.config.getCustomLdapFilter();
        if (customFilter != null && customFilter.trim().length() > 0) {
            Condition customFilterCondition = new LDAPQueryConditionsBuilder().addCustomLDAPFilter(customFilter);
            ldapQuery.addWhereCondition(customFilterCondition);
        }
        ldapQuery.addReturningLdapAttribute(this.config.getGroupNameLdapAttribute());
        ldapQuery.addReturningLdapAttribute(this.config.getMembershipLdapAttribute());
        for (String groupAttr : this.config.getGroupAttributes()) {
            ldapQuery.addReturningLdapAttribute(groupAttr);
        }
        return ldapQuery;
    }

    public LDAPObject createLDAPGroup(String groupName, Map<String, Set<String>> additionalAttributes) {
        LDAPObject ldapGroup = LDAPUtils.createLDAPGroup(this.ldapProvider, groupName, this.config.getGroupNameLdapAttribute(), this.config.getGroupObjectClasses(this.ldapProvider), this.config.getGroupsDn(), additionalAttributes);
        logger.debugf("Creating group [%s] to LDAP with DN [%s]", (Object)groupName, (Object)ldapGroup.getDn().toString());
        return ldapGroup;
    }

    public LDAPObject loadLDAPGroupByName(String groupName) {
        LDAPQuery ldapQuery = this.createGroupQuery();
        Condition roleNameCondition = new LDAPQueryConditionsBuilder().equal(this.config.getGroupNameLdapAttribute(), groupName);
        ldapQuery.addWhereCondition(roleNameCondition);
        return ldapQuery.getFirstResult();
    }

    protected Set<LDAPDn> getLDAPSubgroups(LDAPObject ldapGroup) {
        MembershipType membershipType = this.config.getMembershipTypeLdapAttribute();
        return membershipType.getLDAPSubgroups(this, ldapGroup);
    }

    @Override
    public UserFederationSyncResult syncDataFromFederationProviderToKeycloak() {
        UserFederationSyncResult syncResult = new UserFederationSyncResult(){

            public String getStatus() {
                return String.format("%d imported groups, %d updated groups, %d removed groups", this.getAdded(), this.getUpdated(), this.getRemoved());
            }
        };
        logger.debugf("Syncing groups from LDAP into Keycloak DB. Mapper is [%s], LDAP provider is [%s]", (Object)this.mapperModel.getName(), (Object)this.ldapProvider.getModel().getDisplayName());
        LDAPQuery ldapQuery = this.createGroupQuery();
        List<LDAPObject> ldapGroups = ldapQuery.getResultList();
        HashMap<String, LDAPObject> ldapGroupsMap = new HashMap<String, LDAPObject>();
        LinkedList<GroupTreeResolver.Group> ldapGroupsRep = new LinkedList<GroupTreeResolver.Group>();
        String groupsRdnAttr = this.config.getGroupNameLdapAttribute();
        for (LDAPObject ldapGroup : ldapGroups) {
            String groupName = ldapGroup.getAttributeAsString(groupsRdnAttr);
            HashSet<String> subgroupNames = new HashSet<String>();
            for (LDAPDn groupDn : this.getLDAPSubgroups(ldapGroup)) {
                subgroupNames.add(groupDn.getFirstRdnAttrValue());
            }
            ldapGroupsRep.add(new GroupTreeResolver.Group(groupName, subgroupNames));
            ldapGroupsMap.put(groupName, ldapGroup);
        }
        if (this.config.isPreserveGroupsInheritance()) {
            try {
                List<GroupTreeResolver.GroupTreeEntry> groupTrees = new GroupTreeResolver().resolveGroupTree(ldapGroupsRep);
                this.updateKeycloakGroupTree(groupTrees, ldapGroupsMap, syncResult);
            }
            catch (GroupTreeResolver.GroupTreeResolveException gre) {
                throw new ModelException("Couldn't resolve groups from LDAP. Fix LDAP or skip preserve inheritance. Details: " + gre.getMessage(), (Throwable)gre);
            }
        } else {
            HashSet<String> visitedGroupIds = new HashSet<String>();
            for (Map.Entry groupEntry : ldapGroupsMap.entrySet()) {
                String groupName = (String)groupEntry.getKey();
                GroupModel kcExistingGroup = KeycloakModelUtils.findGroupByPath((RealmModel)this.realm, (String)("/" + groupName));
                if (kcExistingGroup != null) {
                    this.updateAttributesOfKCGroup(kcExistingGroup, (LDAPObject)groupEntry.getValue());
                    syncResult.increaseUpdated();
                    visitedGroupIds.add(kcExistingGroup.getId());
                    continue;
                }
                GroupModel kcGroup = this.realm.createGroup(groupName);
                this.updateAttributesOfKCGroup(kcGroup, (LDAPObject)groupEntry.getValue());
                this.realm.moveGroup(kcGroup, null);
                syncResult.increaseAdded();
                visitedGroupIds.add(kcGroup.getId());
            }
            if (this.config.isDropNonExistingGroupsDuringSync()) {
                this.dropNonExistingKcGroups(syncResult, visitedGroupIds);
            }
        }
        this.syncFromLDAPPerformedInThisTransaction = true;
        return syncResult;
    }

    private void updateKeycloakGroupTree(List<GroupTreeResolver.GroupTreeEntry> groupTrees, Map<String, LDAPObject> ldapGroups, UserFederationSyncResult syncResult) {
        HashSet<String> visitedGroupIds = new HashSet<String>();
        for (GroupTreeResolver.GroupTreeEntry groupEntry : groupTrees) {
            this.updateKeycloakGroupTreeEntry(groupEntry, ldapGroups, null, syncResult, visitedGroupIds);
        }
        if (this.config.isDropNonExistingGroupsDuringSync()) {
            this.dropNonExistingKcGroups(syncResult, visitedGroupIds);
        }
    }

    private void updateKeycloakGroupTreeEntry(GroupTreeResolver.GroupTreeEntry groupTreeEntry, Map<String, LDAPObject> ldapGroups, GroupModel kcParent, UserFederationSyncResult syncResult, Set<String> visitedGroupIds) {
        String groupName = groupTreeEntry.getGroupName();
        GroupModel kcGroup = null;
        Collection subgroups = kcParent == null ? this.realm.getTopLevelGroups() : kcParent.getSubGroups();
        for (GroupModel group : subgroups) {
            if (!group.getName().equals(groupName)) continue;
            kcGroup = group;
            break;
        }
        if (kcGroup != null) {
            logger.debugf("Updated Keycloak group '%s' from LDAP", (Object)kcGroup.getName());
            this.updateAttributesOfKCGroup(kcGroup, ldapGroups.get(kcGroup.getName()));
            syncResult.increaseUpdated();
        } else {
            kcGroup = this.realm.createGroup(groupTreeEntry.getGroupName());
            if (kcParent == null) {
                this.realm.moveGroup(kcGroup, null);
                logger.debugf("Imported top-level group '%s' from LDAP", (Object)kcGroup.getName());
            } else {
                this.realm.moveGroup(kcGroup, kcParent);
                logger.debugf("Imported group '%s' from LDAP as child of group '%s'", (Object)kcGroup.getName(), (Object)kcParent.getName());
            }
            this.updateAttributesOfKCGroup(kcGroup, ldapGroups.get(kcGroup.getName()));
            syncResult.increaseAdded();
        }
        visitedGroupIds.add(kcGroup.getId());
        for (GroupTreeResolver.GroupTreeEntry childEntry : groupTreeEntry.getChildren()) {
            this.updateKeycloakGroupTreeEntry(childEntry, ldapGroups, kcGroup, syncResult, visitedGroupIds);
        }
    }

    private void dropNonExistingKcGroups(UserFederationSyncResult syncResult, Set<String> visitedGroupIds) {
        List allGroups = this.realm.getGroups();
        for (GroupModel kcGroup : allGroups) {
            if (visitedGroupIds.contains(kcGroup.getId())) continue;
            logger.debugf("Removing Keycloak group '%s', which doesn't exist in LDAP", (Object)kcGroup.getName());
            this.realm.removeGroup(kcGroup);
            syncResult.increaseRemoved();
        }
    }

    private void updateAttributesOfKCGroup(GroupModel kcGroup, LDAPObject ldapGroup) {
        Collection<String> groupAttributes = this.config.getGroupAttributes();
        for (String attrName : groupAttributes) {
            Set<String> attrValues = ldapGroup.getAttributeAsSet(attrName);
            if (attrValues == null) {
                kcGroup.removeAttribute(attrName);
                continue;
            }
            kcGroup.setAttribute(attrName, new LinkedList<String>(attrValues));
        }
    }

    protected GroupModel findKcGroupByLDAPGroup(LDAPObject ldapGroup) {
        String groupNameAttr = this.config.getGroupNameLdapAttribute();
        String groupName = ldapGroup.getAttributeAsString(groupNameAttr);
        List groups = this.realm.getGroups();
        for (GroupModel group : groups) {
            if (!group.getName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    protected GroupModel findKcGroupOrSyncFromLDAP(LDAPObject ldapGroup, UserModel user) {
        GroupModel kcGroup = this.findKcGroupByLDAPGroup(ldapGroup);
        if (kcGroup == null) {
            if (!this.syncFromLDAPPerformedInThisTransaction) {
                this.syncDataFromFederationProviderToKeycloak();
                kcGroup = this.findKcGroupByLDAPGroup(ldapGroup);
            }
            if (kcGroup == null) {
                String groupName = ldapGroup.getAttributeAsString(this.config.getGroupNameLdapAttribute());
                logger.warnf("User '%s' is member of group '%s', which doesn't exists in LDAP", (Object)user.getUsername(), (Object)groupName);
            }
        }
        return kcGroup;
    }

    @Override
    public UserFederationSyncResult syncDataFromKeycloakToFederationProvider() {
        UserFederationSyncResult syncResult = new UserFederationSyncResult(){

            public String getStatus() {
                return String.format("%d groups imported to LDAP, %d groups updated to LDAP, %d groups removed from LDAP", this.getAdded(), this.getUpdated(), this.getRemoved());
            }
        };
        if (this.config.getMode() != LDAPGroupMapperMode.LDAP_ONLY) {
            logger.warnf("Ignored sync for federation mapper '%s' as it's mode is '%s'", (Object)this.mapperModel.getName(), (Object)this.config.getMode().toString());
            return syncResult;
        }
        logger.debugf("Syncing groups from Keycloak into LDAP. Mapper is [%s], LDAP provider is [%s]", (Object)this.mapperModel.getName(), (Object)this.ldapProvider.getModel().getDisplayName());
        LDAPQuery ldapQuery = this.createGroupQuery();
        List<LDAPObject> ldapGroups = ldapQuery.getResultList();
        HashMap<String, LDAPObject> ldapGroupsMap = new HashMap<String, LDAPObject>();
        String groupsRdnAttr = this.config.getGroupNameLdapAttribute();
        for (LDAPObject lDAPObject : ldapGroups) {
            String groupName = lDAPObject.getAttributeAsString(groupsRdnAttr);
            ldapGroupsMap.put(groupName, lDAPObject);
        }
        HashSet<String> ldapGroupNames = new HashSet<String>();
        for (Object kcGroup : this.realm.getTopLevelGroups()) {
            this.processLdapGroupSyncToLDAP((GroupModel)kcGroup, ldapGroupsMap, ldapGroupNames, syncResult);
        }
        if (this.config.isDropNonExistingGroupsDuringSync()) {
            HashSet hashSet = new HashSet(ldapGroupsMap.keySet());
            for (String groupName : hashSet) {
                if (ldapGroupNames.contains(groupName)) continue;
                LDAPObject ldapGroup = (LDAPObject)ldapGroupsMap.remove(groupName);
                this.ldapProvider.getLdapIdentityStore().remove(ldapGroup);
                syncResult.increaseRemoved();
            }
        }
        if (this.config.isPreserveGroupsInheritance()) {
            for (Object kcGroup : this.realm.getTopLevelGroups()) {
                this.processLdapGroupMembershipsSyncToLDAP((GroupModel)kcGroup, ldapGroupsMap);
            }
        }
        return syncResult;
    }

    private void processLdapGroupSyncToLDAP(GroupModel kcGroup, Map<String, LDAPObject> ldapGroupsMap, Set<String> ldapGroupNames, UserFederationSyncResult syncResult) {
        String groupName = kcGroup.getName();
        HashMap<String, Set<String>> supportedLdapAttributes = new HashMap<String, Set<String>>();
        for (String attrName : this.config.getGroupAttributes()) {
            List kcAttrValues = kcGroup.getAttribute(attrName);
            HashSet attrValues2 = kcAttrValues == null || kcAttrValues.isEmpty() ? null : new HashSet(kcAttrValues);
            supportedLdapAttributes.put(attrName, attrValues2);
        }
        LDAPObject ldapGroup = ldapGroupsMap.get(groupName);
        if (ldapGroup == null) {
            ldapGroup = this.createLDAPGroup(groupName, supportedLdapAttributes);
            syncResult.increaseAdded();
        } else {
            for (Map.Entry attrEntry : supportedLdapAttributes.entrySet()) {
                ldapGroup.setAttribute((String)attrEntry.getKey(), (Set)attrEntry.getValue());
            }
            this.ldapProvider.getLdapIdentityStore().update(ldapGroup);
            syncResult.increaseUpdated();
        }
        ldapGroupsMap.put(groupName, ldapGroup);
        ldapGroupNames.add(groupName);
        for (GroupModel kcSubgroup : kcGroup.getSubGroups()) {
            this.processLdapGroupSyncToLDAP(kcSubgroup, ldapGroupsMap, ldapGroupNames, syncResult);
        }
    }

    private void processLdapGroupMembershipsSyncToLDAP(GroupModel kcGroup, Map<String, LDAPObject> ldapGroupsMap) {
        LDAPObject ldapGroup = ldapGroupsMap.get(kcGroup.getName());
        Set<LDAPDn> toRemoveSubgroupsDNs = this.getLDAPSubgroups(ldapGroup);
        Set kcSubgroups = kcGroup.getSubGroups();
        for (GroupModel kcSubgroup : kcSubgroups) {
            LDAPObject ldapSubgroup = ldapGroupsMap.get(kcSubgroup.getName());
            LDAPUtils.addMember(this.ldapProvider, MembershipType.DN, this.config.getMembershipLdapAttribute(), ldapGroup, ldapSubgroup, false);
            toRemoveSubgroupsDNs.remove(ldapSubgroup.getDn());
        }
        for (LDAPDn toRemoveDN : toRemoveSubgroupsDNs) {
            LDAPObject fakeGroup = new LDAPObject();
            fakeGroup.setDn(toRemoveDN);
            LDAPUtils.deleteMember(this.ldapProvider, MembershipType.DN, this.config.getMembershipLdapAttribute(), ldapGroup, fakeGroup, false);
        }
        if (!kcGroup.getSubGroups().isEmpty() || !toRemoveSubgroupsDNs.isEmpty()) {
            this.ldapProvider.getLdapIdentityStore().update(ldapGroup);
        }
        for (GroupModel kcSubgroup : kcGroup.getSubGroups()) {
            this.processLdapGroupMembershipsSyncToLDAP(kcSubgroup, ldapGroupsMap);
        }
    }

    @Override
    public List<UserModel> getGroupMembers(GroupModel kcGroup, int firstResult, int maxResults) {
        LDAPObject ldapGroup = this.loadLDAPGroupByName(kcGroup.getName());
        if (ldapGroup == null) {
            return Collections.emptyList();
        }
        MembershipType membershipType = this.config.getMembershipTypeLdapAttribute();
        return membershipType.getGroupMembers(this, ldapGroup, firstResult, maxResults);
    }

    public void addGroupMappingInLDAP(String groupName, LDAPObject ldapUser) {
        LDAPObject ldapGroup = this.loadLDAPGroupByName(groupName);
        if (ldapGroup == null) {
            this.syncDataFromKeycloakToFederationProvider();
            ldapGroup = this.loadLDAPGroupByName(groupName);
        }
        LDAPUtils.addMember(this.ldapProvider, this.config.getMembershipTypeLdapAttribute(), this.config.getMembershipLdapAttribute(), ldapGroup, ldapUser, true);
    }

    public void deleteGroupMappingInLDAP(LDAPObject ldapUser, LDAPObject ldapGroup) {
        LDAPUtils.deleteMember(this.ldapProvider, this.config.getMembershipTypeLdapAttribute(), this.config.getMembershipLdapAttribute(), ldapGroup, ldapUser, true);
    }

    protected List<LDAPObject> getLDAPGroupMappings(LDAPObject ldapUser) {
        String strategyKey = this.config.getUserGroupsRetrieveStrategy();
        UserRolesRetrieveStrategy strategy = this.factory.getUserGroupsRetrieveStrategy(strategyKey);
        return strategy.getLDAPRoleMappings(this, ldapUser);
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
        String strategyKey = this.config.getUserGroupsRetrieveStrategy();
        UserRolesRetrieveStrategy strategy = this.factory.getUserGroupsRetrieveStrategy(strategyKey);
        strategy.beforeUserLDAPQuery(query);
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate) {
        LDAPGroupMapperMode mode = this.config.getMode();
        if (mode == LDAPGroupMapperMode.IMPORT) {
            return delegate;
        }
        return new LDAPGroupMappingsUserDelegate(delegate, ldapUser);
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser) {
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, boolean isCreate) {
        LDAPGroupMapperMode mode = this.config.getMode();
        if (mode == LDAPGroupMapperMode.IMPORT && isCreate) {
            List<LDAPObject> ldapGroups = this.getLDAPGroupMappings(ldapUser);
            for (LDAPObject ldapGroup : ldapGroups) {
                GroupModel kcGroup = this.findKcGroupOrSyncFromLDAP(ldapGroup, user);
                if (kcGroup == null) continue;
                logger.debugf("User '%s' joins group '%s' during import from LDAP", (Object)user.getUsername(), (Object)kcGroup.getName());
                user.joinGroup(kcGroup);
            }
        }
    }

    public class LDAPGroupMappingsUserDelegate
    extends UserModelDelegate {
        private final LDAPObject ldapUser;
        private Set<GroupModel> cachedLDAPGroupMappings;

        public LDAPGroupMappingsUserDelegate(UserModel user, LDAPObject ldapUser) {
            super(user);
            this.ldapUser = ldapUser;
        }

        public Set<GroupModel> getGroups() {
            Set<GroupModel> ldapGroupMappings = this.getLDAPGroupMappingsConverted();
            if (GroupLDAPFederationMapper.this.config.getMode() == LDAPGroupMapperMode.LDAP_ONLY) {
                return ldapGroupMappings;
            }
            Set modelGroupMappings = super.getGroups();
            ldapGroupMappings.addAll(modelGroupMappings);
            return ldapGroupMappings;
        }

        public void joinGroup(GroupModel group) {
            if (GroupLDAPFederationMapper.this.config.getMode() == LDAPGroupMapperMode.LDAP_ONLY) {
                this.cachedLDAPGroupMappings = null;
                GroupLDAPFederationMapper.this.addGroupMappingInLDAP(group.getName(), this.ldapUser);
            } else {
                super.joinGroup(group);
            }
        }

        public void leaveGroup(GroupModel group) {
            LDAPQuery ldapQuery = GroupLDAPFederationMapper.this.createGroupQuery();
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            Condition roleNameCondition = conditionsBuilder.equal(GroupLDAPFederationMapper.this.config.getGroupNameLdapAttribute(), group.getName());
            String membershipUserAttr = LDAPUtils.getMemberValueOfChildObject(this.ldapUser, GroupLDAPFederationMapper.this.config.getMembershipTypeLdapAttribute());
            Condition membershipCondition = conditionsBuilder.equal(GroupLDAPFederationMapper.this.config.getMembershipLdapAttribute(), membershipUserAttr);
            ldapQuery.addWhereCondition(roleNameCondition).addWhereCondition(membershipCondition);
            LDAPObject ldapGroup = ldapQuery.getFirstResult();
            if (ldapGroup == null) {
                if (GroupLDAPFederationMapper.this.config.getMode() == LDAPGroupMapperMode.READ_ONLY) {
                    super.leaveGroup(group);
                }
            } else {
                if (GroupLDAPFederationMapper.this.config.getMode() == LDAPGroupMapperMode.READ_ONLY) {
                    throw new ModelException("Not possible to delete LDAP group mappings as mapper mode is READ_ONLY");
                }
                this.cachedLDAPGroupMappings = null;
                GroupLDAPFederationMapper.this.deleteGroupMappingInLDAP(this.ldapUser, ldapGroup);
            }
        }

        public boolean isMemberOf(GroupModel group) {
            Set<GroupModel> ldapGroupMappings = this.getGroups();
            return ldapGroupMappings.contains(group);
        }

        protected Set<GroupModel> getLDAPGroupMappingsConverted() {
            if (this.cachedLDAPGroupMappings != null) {
                return new HashSet<GroupModel>(this.cachedLDAPGroupMappings);
            }
            List<LDAPObject> ldapGroups = GroupLDAPFederationMapper.this.getLDAPGroupMappings(this.ldapUser);
            HashSet<GroupModel> result = new HashSet<GroupModel>();
            for (LDAPObject ldapGroup : ldapGroups) {
                GroupModel kcGroup = GroupLDAPFederationMapper.this.findKcGroupOrSyncFromLDAP(ldapGroup, (UserModel)this);
                if (kcGroup == null) continue;
                result.add(kcGroup);
            }
            this.cachedLDAPGroupMappings = new HashSet<GroupModel>(result);
            return result;
        }
    }
}

