/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.transform.CombinedTransformer;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.DatabaseDataStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.FileDataStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.TimerServiceAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TimerServiceResourceDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition THREAD_POOL_NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("thread-pool-name", ModelType.STRING, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final SimpleAttributeDefinition DEFAULT_DATA_STORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-data-store", ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowNull(false)).build();
    public static final Map<String, AttributeDefinition> ATTRIBUTES;
    private final PathManager pathManager;

    public TimerServiceResourceDefinition(PathManager pathManager) {
        super(EJB3SubsystemModel.TIMER_SERVICE_PATH, EJB3Extension.getResourceDescriptionResolver("timer-service"), (OperationStepHandler)TimerServiceAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_ALL_SERVICES);
        this.pathManager = pathManager;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : ATTRIBUTES.values()) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{attr}));
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new FileDataStoreResourceDefinition(this.pathManager));
        resourceRegistration.registerSubModel((ResourceDefinition)DatabaseDataStoreResourceDefinition.INSTANCE);
    }

    static void registerTransformers_1_2_0(ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder timerService = parent.addChildResource(EJB3SubsystemModel.TIMER_SERVICE_PATH);
        TimerServiceResourceDefinition.registerDataStoreTransformers(timerService);
    }

    private static void registerDataStoreTransformers(ResourceTransformationDescriptionBuilder timerService) {
        DataStoreTransformer dataStoreTransformer = new DataStoreTransformer();
        ((AttributeTransformationDescriptionBuilder)timerService.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new String[]{"default-data-store"})).end();
        timerService.discardOperations(new String[]{"add"});
        timerService.setCustomResourceTransformer((ResourceTransformer)dataStoreTransformer);
        timerService.rejectChildResource(EJB3SubsystemModel.DATABASE_DATA_STORE_PATH);
        ResourceTransformationDescriptionBuilder fileDataStore = timerService.addChildRedirection(EJB3SubsystemModel.FILE_DATA_STORE_PATH, new PathAddressTransformer(){

            public PathAddress transform(PathElement current, PathAddressTransformer.Builder builder) {
                return builder.getCurrent();
            }
        });
        fileDataStore.addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer((OperationTransformer)dataStoreTransformer).end();
    }

    public static void registerTransformers_1_3_0(ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder timerService = parent.addChildResource(EJB3SubsystemModel.TIMER_SERVICE_PATH);
        DatabaseDataStoreResourceDefinition.registerTransformers1_3_0(timerService);
    }

    static {
        LinkedHashMap<String, SimpleAttributeDefinition> map = new LinkedHashMap<String, SimpleAttributeDefinition>();
        map.put(THREAD_POOL_NAME.getName(), THREAD_POOL_NAME);
        map.put(DEFAULT_DATA_STORE.getName(), DEFAULT_DATA_STORE);
        ATTRIBUTES = Collections.unmodifiableMap(map);
    }

    private static class DataStoreTransformer
    implements CombinedTransformer {
        private DataStoreTransformer() {
        }

        public OperationTransformer.TransformedOperation transformOperation(final TransformationContext context, final PathAddress address, final ModelNode operation) throws OperationFailedException {
            Resource original = context.readResourceFromRoot(address);
            String defaultDataStore = original.getModel().get(DEFAULT_DATA_STORE.getName()).asString();
            boolean hasFileDataStore = original.hasChild(PathElement.pathElement((String)EJB3SubsystemModel.FILE_DATA_STORE_PATH.getKey(), (String)defaultDataStore));
            if (original.getChildren("file-data-store").size() > 1 || !hasFileDataStore) {
                return new OperationTransformer.TransformedOperation(operation, new OperationRejectionPolicy(){

                    public boolean rejectOperation(ModelNode preparedResult) {
                        return true;
                    }

                    public String getFailureDescription() {
                        return context.getLogger().getRejectedResourceWarning(address, operation);
                    }
                }, OperationResultTransformer.ORIGINAL_RESULT);
            }
            operation.get(THREAD_POOL_NAME.getName()).set(original.getModel().get(THREAD_POOL_NAME.getName()));
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }

        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
            Resource untransformedResource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode untransformedModel = Resource.Tools.readModel((Resource)untransformedResource);
            String defaultDataStore = untransformedModel.get(DEFAULT_DATA_STORE.getName()).asString();
            ModelNode transformed = resource.getModel();
            transformed.remove(DEFAULT_DATA_STORE.getName());
            ModelNode fileStore = untransformedModel.get(new String[]{"file-data-store", defaultDataStore});
            if (!fileStore.isDefined()) {
                this.rejectIncompatibleDataStores(context, address);
            } else if (untransformedModel.hasDefined("database-data-store") && untransformedModel.get("database-data-store").keys().size() > 0 || untransformedModel.get("file-data-store").keys().size() > 1) {
                this.rejectIncompatibleDataStores(context, address);
            }
            ModelNode path = fileStore.get("path");
            transformed.get("path").set(path);
            transformed.get("relative-to").set(fileStore.get("relative-to"));
            context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
        }

        private void rejectIncompatibleDataStores(ResourceTransformationContext context, PathAddress address) throws OperationFailedException {
            TransformationTarget tgt = context.getTarget();
            throw new OperationFailedException(EjbLogger.ROOT_LOGGER.untransformableTimerService(address));
        }
    }
}

