/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.ejb.EJBObject;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.Logs;
import org.jboss.marshalling.FieldSetter;

public final class EntityEJBLocator<T extends EJBObject>
extends EJBLocator<T> {
    private static final long serialVersionUID = 6674116259124568398L;
    private final Object primaryKey;
    private final transient int hashCode;
    private static final FieldSetter hashCodeSetter = FieldSetter.get(EntityEJBLocator.class, (String)"hashCode");

    public EntityEJBLocator(Class<T> viewType, String appName, String moduleName, String beanName, Object primaryKey) {
        this(viewType, appName, moduleName, beanName, null, primaryKey, Affinity.NONE);
    }

    public EntityEJBLocator(Class<T> viewType, String appName, String moduleName, String beanName, Object primaryKey, Affinity affinity) {
        this(viewType, appName, moduleName, beanName, null, primaryKey, affinity);
    }

    public EntityEJBLocator(Class<T> viewType, String appName, String moduleName, String beanName, String distinctName, Object primaryKey) {
        this(viewType, appName, moduleName, beanName, distinctName, primaryKey, Affinity.NONE);
    }

    public EntityEJBLocator(Class<T> viewType, String appName, String moduleName, String beanName, String distinctName, Object primaryKey, Affinity affinity) {
        super(viewType, appName, moduleName, beanName, distinctName, affinity);
        if (primaryKey == null) {
            throw Logs.MAIN.paramCannotBeNull("primary key");
        }
        this.primaryKey = primaryKey;
        this.hashCode = primaryKey.hashCode() * 13 + super.hashCode();
    }

    public EntityEJBLocator(EntityEJBLocator<T> original, Affinity newAffinity) {
        super(original, newAffinity);
        this.primaryKey = original.primaryKey;
        this.hashCode = this.primaryKey.hashCode() * 13 + super.hashCode();
    }

    @Override
    public EJBLocator<T> withNewAffinity(Affinity affinity) {
        return new EntityEJBLocator<T>(this, affinity);
    }

    @Override
    public <S> EntityEJBLocator<? extends S> narrowTo(Class<S> type) {
        return (EntityEJBLocator)super.narrowTo(type);
    }

    @Override
    public <S extends EJBObject> EntityEJBLocator<? extends S> narrowAsEntity(Class<S> type) {
        if (type.isAssignableFrom(this.getViewType())) {
            return this;
        }
        throw new ClassCastException(type.toString());
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof EntityEJBLocator && this.equals((EntityEJBLocator)other);
    }

    @Override
    public boolean equals(EJBLocator<?> other) {
        return other instanceof EntityEJBLocator && this.equals((EntityEJBLocator)other);
    }

    @Override
    public boolean equals(EntityEJBLocator<?> other) {
        return super.equals(other) && this.primaryKey.equals(other.primaryKey);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        hashCodeSetter.setInt((Object)this, this.primaryKey.hashCode() * 13 + super.hashCode());
    }

    @Override
    public String toString() {
        return String.format("%s, primary key is %s", super.toString(), this.getPrimaryKey());
    }
}

