/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.jpa.config.Configuration;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.config.PersistenceUnitsInApplication;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.JPADeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class JPADependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier JAVAX_PERSISTENCE_API_ID = ModuleIdentifier.create((String)"javax.persistence.api");
    private static final ModuleIdentifier JBOSS_AS_JPA_ID = ModuleIdentifier.create((String)"org.jboss.as.jpa");
    private static final ModuleIdentifier JBOSS_AS_JPA_SPI_ID = ModuleIdentifier.create((String)"org.jboss.as.jpa.spi");
    private static final ModuleIdentifier JAVASSIST_ID = ModuleIdentifier.create((String)"org.javassist");
    private static final ModuleIdentifier HIBERNATE_3_PROVIDER = ModuleIdentifier.create((String)"org.jboss.as.jpa.hibernate", (String)"3");
    private static final String HIBERNATE3_PROVIDER_ADAPTOR = "org.jboss.as.jpa.hibernate3.HibernatePersistenceProviderAdaptor";
    private static final ModuleIdentifier JBOSS_AS_NAMING_ID = ModuleIdentifier.create((String)"org.jboss.as.naming");
    private static final ModuleIdentifier JBOSS_JANDEX_ID = ModuleIdentifier.create((String)"org.jboss.jandex");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDependency(moduleSpecification, moduleLoader, deploymentUnit, JAVAX_PERSISTENCE_API_ID);
        if (!JPADeploymentMarker.isJPADeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        this.addDependency(moduleSpecification, moduleLoader, deploymentUnit, JBOSS_AS_JPA_ID, JBOSS_AS_JPA_SPI_ID, JAVASSIST_ID);
        this.addPersistenceProviderModuleDependencies(phaseContext, moduleSpecification, moduleLoader);
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, DeploymentUnit deploymentUnit, ModuleIdentifier ... moduleIdentifiers) {
        for (ModuleIdentifier moduleIdentifier : moduleIdentifiers) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, true, false));
            JpaLogger.ROOT_LOGGER.debugf("added %s dependency to %s", moduleIdentifier, deploymentUnit.getName());
        }
    }

    private void addOptionalDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, DeploymentUnit deploymentUnit, ModuleIdentifier ... moduleIdentifiers) {
        for (ModuleIdentifier moduleIdentifier : moduleIdentifiers) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, true, false, false, false));
            JpaLogger.ROOT_LOGGER.debugf("added %s dependency to %s", moduleIdentifier, deploymentUnit.getName());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void addPersistenceProviderModuleDependencies(DeploymentPhaseContext phaseContext, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        int defaultProviderCount = 0;
        HashSet<String> moduleDependencies = new HashSet<String>();
        PersistenceUnitsInApplication persistenceUnitsInApplication = (PersistenceUnitsInApplication)DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit).getAttachment(PersistenceUnitsInApplication.PERSISTENCE_UNITS_IN_APPLICATION);
        for (PersistenceUnitMetadataHolder holder : persistenceUnitsInApplication.getPersistenceUnitHolders()) {
            defaultProviderCount += this.loadPersistenceUnits(moduleSpecification, moduleLoader, deploymentUnit, moduleDependencies, holder);
        }
        if (defaultProviderCount > 0) {
            moduleDependencies.add(Configuration.getDefaultProviderModuleName());
            JpaLogger.ROOT_LOGGER.debugf("added (default provider) %s dependency to %s (since %d PU(s) didn't specify %s", new Object[]{Configuration.getDefaultProviderModuleName(), deploymentUnit.getName(), defaultProviderCount, "jboss.as.jpa.providerModule)"});
        }
        for (String dependency : moduleDependencies) {
            this.addDependency(moduleSpecification, moduleLoader, deploymentUnit, ModuleIdentifier.fromString((String)dependency));
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Collection components = eeModuleDescription.getComponentDescriptions();
        for (PersistenceUnitMetadataHolder holder : persistenceUnitsInApplication.getPersistenceUnitHolders()) {
            JPADependencyProcessor.addPUServiceDependencyToComponents(components, holder);
        }
    }

    private static void addPUServiceDependencyToComponents(Collection<ComponentDescription> components, PersistenceUnitMetadataHolder holder) {
        if (components == null || components.isEmpty() || holder == null) {
            return;
        }
        for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
            String jpaContainerManaged = pu.getProperties().getProperty("jboss.as.jpa.managed");
            boolean deployPU = jpaContainerManaged == null ? true : Boolean.parseBoolean(jpaContainerManaged);
            if (!deployPU) continue;
            ServiceName puServiceName = PersistenceUnitServiceImpl.getPUServiceName(pu);
            for (ComponentDescription component : components) {
                JpaLogger.ROOT_LOGGER.debugf("Adding dependency on PU service %s for component %s", puServiceName, component.getComponentClassName());
                component.addDependency(puServiceName, ServiceBuilder.DependencyType.REQUIRED);
            }
        }
    }

    private int loadPersistenceUnits(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, DeploymentUnit deploymentUnit, Set<String> moduleDependencies, PersistenceUnitMetadataHolder holder) throws DeploymentUnitProcessingException {
        int defaultProviderCount = 0;
        if (holder != null) {
            for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                String providerModule = pu.getProperties().getProperty("jboss.as.jpa.providerModule");
                String adapterModule = pu.getProperties().getProperty("jboss.as.jpa.adapterModule");
                String adapterClass = pu.getProperties().getProperty("jboss.as.jpa.adapterClass");
                if (adapterModule != null) {
                    JpaLogger.ROOT_LOGGER.debugf("%s is configured to use adapter module '%s'", pu.getPersistenceUnitName(), adapterModule);
                    moduleDependencies.add(adapterModule);
                }
                deploymentUnit.putAttachment(JpaAttachments.ADAPTOR_CLASS_NAME, (Object)adapterClass);
                String provider = pu.getProperties().getProperty("jboss.as.jpa.providerModule");
                if (provider != null) {
                    if (provider.equals("application")) {
                        JpaLogger.ROOT_LOGGER.debugf("%s is configured to use application supplied persistence provider", pu.getPersistenceUnitName());
                        continue;
                    }
                    moduleDependencies.add(provider);
                    JpaLogger.ROOT_LOGGER.debugf("%s is configured to use provider module '%s'", pu.getPersistenceUnitName(), provider);
                    continue;
                }
                if ("org.hibernate.jpa.HibernatePersistenceProvider".equals(pu.getPersistenceProviderClassName())) {
                    ++defaultProviderCount;
                    continue;
                }
                String providerModuleName = Configuration.getProviderModuleNameFromProviderClassName(pu.getPersistenceProviderClassName());
                if (providerModuleName == null) continue;
                this.addOptionalDependency(moduleSpecification, moduleLoader, deploymentUnit, ModuleIdentifier.fromString((String)providerModuleName));
                JpaLogger.ROOT_LOGGER.debugf("%s is configured to use persistence provider '%s', adding an optional dependency on module '%s'", pu.getPersistenceUnitName(), pu.getPersistenceProviderClassName(), providerModuleName);
            }
        }
        return defaultProviderCount;
    }

    private void addHibernate3AdaptorToDeployment(ModuleLoader moduleLoader, DeploymentUnit deploymentUnit) {
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE_SPECIFICATION);
        try {
            Module module = moduleLoader.loadModule(HIBERNATE_3_PROVIDER);
            URL url = module.getClassLoader().getResource(HIBERNATE3_PROVIDER_ADAPTOR.replace('.', '/') + ".class");
            URLConnection connection = url.openConnection();
            if (!(connection instanceof JarURLConnection)) {
                throw JpaLogger.ROOT_LOGGER.invalidUrlConnection("hibernate 3", connection);
            }
            JarFile jarFile = ((JarURLConnection)connection).getJarFile();
            moduleSpecification.addResourceLoader(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((String)"hibernate3integration", (JarFile)jarFile)));
            this.addDependency(moduleSpecification, moduleLoader, deploymentUnit, JBOSS_AS_NAMING_ID, JBOSS_JANDEX_ID);
        }
        catch (ModuleLoadException e) {
            throw JpaLogger.ROOT_LOGGER.cannotLoadModule(e, HIBERNATE_3_PROVIDER, "hibernate 3");
        }
        catch (MalformedURLException e) {
            throw JpaLogger.ROOT_LOGGER.cannotAddIntegration(e, "hibernate 3");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

