/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.snapshot.SnapshotListener;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.DatabaseObjectFactory;

public class SnapshotControl
implements LiquibaseSerializable {
    private Set<Class<? extends DatabaseObject>> types;
    private SnapshotListener snapshotListener;

    public SnapshotControl(Database database) {
        this.setTypes(DatabaseObjectFactory.getInstance().getStandardTypes(), database);
    }

    public SnapshotControl(Database database, Class<? extends DatabaseObject> ... types) {
        this(database, true, types);
    }

    public SnapshotControl(Database database, boolean expandTypesIfNeeded, Class<? extends DatabaseObject> ... types) {
        if (types == null || types.length == 0) {
            this.setTypes(DatabaseObjectFactory.getInstance().getStandardTypes(), database);
        } else if (expandTypesIfNeeded) {
            this.setTypes(new HashSet<Class<? extends DatabaseObject>>(Arrays.asList(types)), database);
        } else {
            this.types = new HashSet<Class<? extends DatabaseObject>>(Arrays.asList(types));
        }
    }

    public SnapshotControl(Database database, String types) {
        this.setTypes(DatabaseObjectFactory.getInstance().parseTypes(types), database);
    }

    public SnapshotListener getSnapshotListener() {
        return this.snapshotListener;
    }

    public void setSnapshotListener(SnapshotListener snapshotListener) {
        this.snapshotListener = snapshotListener;
    }

    @Override
    public String getSerializedObjectName() {
        return "snapshotControl";
    }

    @Override
    public Set<String> getSerializableFields() {
        return new HashSet<String>(Arrays.asList("includedType"));
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        if (field.equals("includedType")) {
            TreeSet<String> types = new TreeSet<String>();
            for (Class<? extends DatabaseObject> type : this.getTypesToInclude()) {
                types.add(type.getName());
            }
            return types;
        }
        throw new UnexpectedLiquibaseException("Unknown field " + field);
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        if (field.equals("includedType")) {
            return LiquibaseSerializable.SerializationType.NESTED_OBJECT;
        }
        throw new UnexpectedLiquibaseException("Unknown field " + field);
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/snapshot";
    }

    @Override
    public String getSerializableFieldNamespace(String field) {
        return this.getSerializedObjectNamespace();
    }

    private void setTypes(Set<Class<? extends DatabaseObject>> types, Database database) {
        this.types = new HashSet<Class<? extends DatabaseObject>>();
        for (Class<? extends DatabaseObject> type : types) {
            this.addType(type, database);
        }
    }

    public boolean addType(Class<? extends DatabaseObject> type, Database database) {
        boolean added = this.types.add(type);
        if (added) {
            for (Class<? extends DatabaseObject> container : SnapshotGeneratorFactory.getInstance().getContainerTypes(type, database)) {
                this.addType(container, database);
            }
        }
        return added;
    }

    public Set<Class<? extends DatabaseObject>> getTypesToInclude() {
        return this.types;
    }

    public boolean shouldInclude(Class<? extends DatabaseObject> type) {
        return this.types.contains(type);
    }

    @Override
    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        throw new RuntimeException("TODO");
    }

    @Override
    public ParsedNode serialize() {
        throw new RuntimeException("TODO");
    }
}

