/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.idm.query.internal;

import java.util.Date;
import org.keycloak.federation.ldap.idm.query.internal.NamedParameterCondition;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPUtil;

class GreaterThanCondition
extends NamedParameterCondition {
    private final boolean orEqual;
    private final Comparable value;

    public GreaterThanCondition(String name, Comparable value, boolean orEqual) {
        super(name);
        this.value = value;
        this.orEqual = orEqual;
    }

    @Override
    public void applyCondition(StringBuilder filter) {
        Object parameterValue = this.value;
        if (Date.class.isInstance(parameterValue)) {
            parameterValue = LDAPUtil.formatDate((Date)parameterValue);
        }
        if (this.orEqual) {
            filter.append("(").append(this.getParameterName()).append(">=").append(parameterValue).append(")");
        } else {
            filter.append("(").append(this.getParameterName()).append(">").append(parameterValue).append(")");
        }
    }
}

