/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import java.util.HashSet;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.internal.EqualCondition;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.TxAwareLDAPUserModelDelegate;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserModel;

public class FullNameLDAPFederationMapper
extends AbstractLDAPFederationMapper {
    public static final String LDAP_FULL_NAME_ATTRIBUTE = "ldap.full.name.attribute";
    public static final String READ_ONLY = "read.only";

    public FullNameLDAPFederationMapper(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, RealmModel realm) {
        super(mapperModel, ldapProvider, realm);
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, boolean isCreate) {
        String ldapFullNameAttrName = this.getLdapFullNameAttrName();
        String fullName = ldapUser.getAttributeAsString(ldapFullNameAttrName);
        if (fullName == null) {
            return;
        }
        if (!(fullName = fullName.trim()).isEmpty()) {
            int lastSpaceIndex = fullName.lastIndexOf(" ");
            if (lastSpaceIndex == -1) {
                user.setLastName(fullName);
            } else {
                user.setFirstName(fullName.substring(0, lastSpaceIndex));
                user.setLastName(fullName.substring(lastSpaceIndex + 1));
            }
        }
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser) {
        String ldapFullNameAttrName = this.getLdapFullNameAttrName();
        String fullName = this.getFullName(localUser.getFirstName(), localUser.getLastName());
        ldapUser.setSingleAttribute(ldapFullNameAttrName, fullName);
        if (this.isReadOnly()) {
            ldapUser.addReadOnlyAttributeName(ldapFullNameAttrName);
        }
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate) {
        if (this.ldapProvider.getEditMode() == UserFederationProvider.EditMode.WRITABLE && !this.isReadOnly()) {
            TxAwareLDAPUserModelDelegate txDelegate = new TxAwareLDAPUserModelDelegate(delegate, this.ldapProvider, ldapUser){

                public void setFirstName(String firstName) {
                    super.setFirstName(firstName);
                    this.setFullNameToLDAPObject();
                }

                public void setLastName(String lastName) {
                    super.setLastName(lastName);
                    this.setFullNameToLDAPObject();
                }

                private void setFullNameToLDAPObject() {
                    String fullName = FullNameLDAPFederationMapper.this.getFullName(this.getFirstName(), this.getLastName());
                    if (logger.isTraceEnabled()) {
                        logger.tracef("Pushing full name attribute to LDAP. Full name: %s", (Object)fullName);
                    }
                    this.ensureTransactionStarted();
                    String ldapFullNameAttrName = FullNameLDAPFederationMapper.this.getLdapFullNameAttrName();
                    this.ldapUser.setSingleAttribute(ldapFullNameAttrName, fullName);
                }
            };
            return txDelegate;
        }
        return delegate;
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
        String ldapFullNameAttrName = this.getLdapFullNameAttrName();
        query.addReturningLdapAttribute(ldapFullNameAttrName);
        EqualCondition firstNameCondition = null;
        EqualCondition lastNameCondition = null;
        HashSet<Condition> conditionsCopy = new HashSet<Condition>(query.getConditions());
        for (Condition condition : conditionsCopy) {
            String paramName = condition.getParameterName();
            if (paramName == null) continue;
            if (paramName.equals("firstName")) {
                firstNameCondition = (EqualCondition)condition;
                query.getConditions().remove(condition);
                continue;
            }
            if (paramName.equals("lastName")) {
                lastNameCondition = (EqualCondition)condition;
                query.getConditions().remove(condition);
                continue;
            }
            if (paramName.equals("givenName")) {
                firstNameCondition = (EqualCondition)condition;
                continue;
            }
            if (!paramName.equals("sn")) continue;
            lastNameCondition = (EqualCondition)condition;
        }
        String fullName = null;
        if (firstNameCondition != null && lastNameCondition != null) {
            fullName = firstNameCondition.getValue() + " " + lastNameCondition.getValue();
        } else if (firstNameCondition != null) {
            fullName = (String)firstNameCondition.getValue();
        } else if (lastNameCondition != null) {
            fullName = (String)lastNameCondition.getValue();
        } else {
            return;
        }
        EqualCondition fullNameCondition = new EqualCondition(ldapFullNameAttrName, fullName);
        query.addWhereCondition(fullNameCondition);
    }

    protected String getLdapFullNameAttrName() {
        String ldapFullNameAttrName = (String)this.mapperModel.getConfig().get(LDAP_FULL_NAME_ATTRIBUTE);
        return ldapFullNameAttrName == null ? "cn" : ldapFullNameAttrName;
    }

    protected String getFullName(String firstName, String lastName) {
        if (firstName != null && lastName != null) {
            return firstName + " " + lastName;
        }
        if (firstName != null) {
            return firstName;
        }
        if (lastName != null) {
            return lastName;
        }
        return " ";
    }

    private boolean isReadOnly() {
        return FullNameLDAPFederationMapper.parseBooleanParameter(this.mapperModel, READ_ONLY);
    }
}

