/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.internal;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.parser.OptionParserException;
import org.jboss.aesh.cl.populator.AeshCommandPopulator;
import org.jboss.aesh.cl.populator.CommandPopulator;
import org.jboss.aesh.cl.result.NullResultHandler;
import org.jboss.aesh.cl.result.ResultHandler;
import org.jboss.aesh.cl.validator.CommandValidator;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.InvocationProviders;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.terminal.TerminalString;

public final class ProcessedCommand<C extends Command> {
    private String name;
    private String description;
    private CommandValidator validator;
    private ResultHandler resultHandler = new NullResultHandler();
    private CommandPopulator populator;
    private List<ProcessedOption> options;
    private ProcessedOption argument;
    private C command;

    public ProcessedCommand(String name, C command, String description, CommandValidator validator, ResultHandler resultHandler, ProcessedOption argument, List<ProcessedOption> options, CommandPopulator populator) throws OptionParserException {
        this.setName(name);
        this.setDescription(description);
        this.validator = validator;
        this.resultHandler = resultHandler;
        this.argument = argument;
        this.options = new ArrayList<ProcessedOption>();
        this.command = command;
        this.populator = populator == null ? new AeshCommandPopulator(this.command) : populator;
        this.setOptions(options);
    }

    public List<ProcessedOption> getOptions() {
        return this.options;
    }

    public void addOption(ProcessedOption opt) throws OptionParserException {
        this.options.add(new ProcessedOption(this.verifyThatNamesAreUnique(opt.getShortName(), opt.getName()), opt.getName(), opt.getDescription(), opt.getArgument(), opt.isRequired(), opt.getValueSeparator(), opt.getDefaultValues(), opt.getType(), opt.getFieldName(), opt.getOptionType(), opt.getConverter(), opt.getCompleter(), opt.getValidator(), opt.getActivator(), opt.getRenderer(), opt.doOverrideRequired()));
    }

    private void setOptions(List<ProcessedOption> options) throws OptionParserException {
        for (ProcessedOption opt : options) {
            this.options.add(new ProcessedOption(this.verifyThatNamesAreUnique(opt.getShortName(), opt.getName()), opt.getName(), opt.getDescription(), opt.getArgument(), opt.isRequired(), opt.getValueSeparator(), opt.getDefaultValues(), opt.getType(), opt.getFieldName(), opt.getOptionType(), opt.getConverter(), opt.getCompleter(), opt.getValidator(), opt.getActivator(), opt.getRenderer(), opt.doOverrideRequired()));
        }
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    public CommandValidator getValidator() {
        return this.validator;
    }

    public ResultHandler getResultHandler() {
        return this.resultHandler;
    }

    public boolean hasArgument() {
        return this.argument != null && this.argument.hasMultipleValues();
    }

    public ProcessedOption getArgument() {
        return this.argument;
    }

    public void setArgument(ProcessedOption argument) {
        this.argument = argument;
    }

    public CommandPopulator getCommandPopulator() {
        return this.populator;
    }

    public C getCommand() {
        return this.command;
    }

    private char verifyThatNamesAreUnique(String name, String longName) throws OptionParserException {
        if (name != null) {
            return this.verifyThatNamesAreUnique(name.charAt(0), longName);
        }
        return this.verifyThatNamesAreUnique('\u0000', longName);
    }

    private char verifyThatNamesAreUnique(char name, String longName) throws OptionParserException {
        if (longName != null && longName.length() > 0 && this.findLongOption(longName) != null) {
            throw new OptionParserException("Option --" + longName + " is already added to Param: " + this.toString());
        }
        if (name != '\u0000' && this.findOption(String.valueOf(name)) != null) {
            throw new OptionParserException("Option -" + name + " is already added to Param: " + this.toString());
        }
        if (name == '\u0000' && (longName == null || longName.length() == 0)) {
            throw new OptionParserException("Neither option name and option long name can be both null");
        }
        return name;
    }

    private char findPossibleName(String longName) throws OptionParserException {
        for (int i = 0; i < longName.length(); ++i) {
            if (this.findOption(String.valueOf(longName.charAt(i))) != null) continue;
            return longName.charAt(i);
        }
        throw new OptionParserException("All option names are taken, please specify a unique name");
    }

    public ProcessedOption findOption(String name) {
        for (ProcessedOption option : this.options) {
            if (option.getShortName() == null || !option.getShortName().equals(name) || !option.getActivator().isActivated(this)) continue;
            return option;
        }
        return null;
    }

    public ProcessedOption findOptionNoActivatorCheck(String name) {
        for (ProcessedOption option : this.options) {
            if (option.getShortName() == null || !option.getShortName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public ProcessedOption findLongOption(String name) {
        for (ProcessedOption option : this.options) {
            if (option.getName() == null || !option.getName().equals(name) || !option.getActivator().isActivated(this)) continue;
            return option;
        }
        return null;
    }

    public ProcessedOption findLongOptionNoActivatorCheck(String name) {
        for (ProcessedOption option : this.options) {
            if (option.getName() == null || !option.getName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public ProcessedOption startWithOption(String name) {
        for (ProcessedOption option : this.options) {
            if (option.getShortName() == null || !name.startsWith(option.getShortName()) || !option.getActivator().isActivated(this)) continue;
            return option;
        }
        return null;
    }

    public ProcessedOption startWithLongOption(String name) {
        for (ProcessedOption option : this.options) {
            if (!name.startsWith(option.getName()) || !option.getActivator().isActivated(this)) continue;
            return option;
        }
        return null;
    }

    public void clear() {
        for (ProcessedOption processedOption : this.options) {
            processedOption.clear();
        }
        if (this.argument != null) {
            this.argument.clear();
        }
    }

    public List<TerminalString> getOptionLongNamesWithDash() {
        ArrayList<TerminalString> names = new ArrayList<TerminalString>(this.options.size());
        for (ProcessedOption o : this.options) {
            if (o.getValues().size() != 0 || !o.getActivator().isActivated(this)) continue;
            names.add(o.getRenderedNameWithDashes());
        }
        return names;
    }

    public List<TerminalString> findPossibleLongNamesWitdDash(String name) {
        ArrayList<TerminalString> names = new ArrayList<TerminalString>(this.options.size());
        for (ProcessedOption o : this.options) {
            if ((o.getShortName() == null || !o.getShortName().equals(name) || o.isLongNameUsed() || o.getValues().size() != 0) && (!o.getName().startsWith(name) || o.getValues().size() != 0) || !o.getActivator().isActivated(this)) continue;
            names.add(o.getRenderedNameWithDashes());
        }
        return names;
    }

    public String printHelp() {
        int maxLength = 0;
        int width = 80;
        for (ProcessedOption o : this.getOptions()) {
            if (o.getFormattedLength() <= maxLength) continue;
            maxLength = o.getFormattedLength();
        }
        StringBuilder sb = new StringBuilder();
        if (this.getOptions().size() > 0) {
            sb.append(Config.getLineSeparator()).append("Options:").append(Config.getLineSeparator());
        }
        for (ProcessedOption o : this.getOptions()) {
            sb.append(o.getFormattedOption(2, maxLength + 4, width)).append(Config.getLineSeparator());
        }
        if (this.argument != null) {
            sb.append(Config.getLineSeparator()).append("Arguments:").append(Config.getLineSeparator());
            sb.append(this.argument.getFormattedOption(2, maxLength + 4, width)).append(Config.getLineSeparator());
        }
        return "Usage: " + this.getName() + " " + this.getDescription() + Config.getLineSeparator() + sb.toString();
    }

    public String toString() {
        return "ProcessedCommand{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", options=" + this.options + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProcessedCommand)) {
            return false;
        }
        ProcessedCommand that = (ProcessedCommand)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(that.description) : that.description != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public boolean hasLongOption(String optionName) {
        for (ProcessedOption o : this.getOptions()) {
            if (!o.getName().equals(optionName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOptions() {
        return this.getOptions() != null && this.getOptions().size() > 0;
    }

    public boolean hasUniqueLongOption(String optionName) {
        if (this.hasLongOption(optionName)) {
            for (ProcessedOption o : this.getOptions()) {
                if (!o.getName().startsWith(optionName) || o.getName().equals(optionName)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void updateInvocationProviders(InvocationProviders invocationProviders) {
        for (ProcessedOption option : this.options) {
            option.updateInvocationProviders(invocationProviders);
        }
    }

    public void updateSettings(Settings settings) {
        for (ProcessedOption option : this.options) {
            option.updateAnsiMode(settings.isAnsiConsole());
        }
    }

    public boolean containsArgumentWithDefaultValues() {
        return this.getArgument() != null && this.getArgument().hasDefaultValue();
    }
}

