/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.XAResourceRecoveryBuilder;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupBuilderProvider;

public class CacheServiceHandler
implements ResourceServiceHandler {
    private final ResourceServiceBuilderFactory<Configuration> builderFactory;
    private final Class<? extends CacheGroupBuilderProvider> providerClass;

    CacheServiceHandler(ResourceServiceBuilderFactory<Configuration> builderFactory, Class<? extends CacheGroupBuilderProvider> providerClass) {
        this.builderFactory = builderFactory;
        this.providerClass = providerClass;
    }

    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress cacheAddress = context.getCurrentAddress();
        PathAddress containerAddress = cacheAddress.getParent();
        String containerName = containerAddress.getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        ServiceTarget target = context.getServiceTarget();
        this.builderFactory.createBuilder(cacheAddress).configure(context, model).build(target).setInitialMode(ServiceController.Mode.PASSIVE).install();
        new CacheBuilder(containerName, cacheName).build(target).install();
        new XAResourceRecoveryBuilder(containerName, cacheName).build(target).install();
        BinderServiceBuilder bindingBuilder = new BinderServiceBuilder(InfinispanBindingFactory.createCacheBinding(containerName, cacheName), CacheServiceName.CACHE.getServiceName(containerName, cacheName), Cache.class);
        String jndiName = ModelNodes.asString((ModelNode)CacheResourceDefinition.Attribute.JNDI_NAME.getDefinition().resolveModelAttribute(context, model));
        if (jndiName != null) {
            bindingBuilder.alias(ContextNames.bindInfoFor((String)JndiNameFactory.parse((String)jndiName).getAbsoluteName()));
        }
        bindingBuilder.build(target).install();
        for (CacheGroupBuilderProvider cacheGroupBuilderProvider : ServiceLoader.load(this.providerClass, this.providerClass.getClassLoader())) {
            for (Builder builder : cacheGroupBuilderProvider.getBuilders(containerName, cacheName)) {
                builder.build(target).install();
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) {
        PathAddress cacheAddress = context.getCurrentAddress();
        PathAddress containerAddress = cacheAddress.getParent();
        String containerName = containerAddress.getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        for (CacheGroupBuilderProvider cacheGroupBuilderProvider : ServiceLoader.load(this.providerClass, this.providerClass.getClassLoader())) {
            for (Builder builder : cacheGroupBuilderProvider.getBuilders(containerName, cacheName)) {
                context.removeService(builder.getServiceName());
            }
        }
        context.removeService(InfinispanBindingFactory.createCacheBinding(containerName, cacheName).getBinderServiceName());
        for (CacheServiceName factory : CacheServiceName.values()) {
            context.removeService(factory.getServiceName(containerName, cacheName));
        }
        context.removeService(this.builderFactory.createBuilder(cacheAddress).getServiceName());
    }
}

