/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.DelegatingModelControllerClient;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.Main;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.as.server.SystemExiter;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.stdio.StdioContext;
import org.jboss.threads.AsyncFuture;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

public class EmbeddedStandaloneServerFactory {
    public static final String JBOSS_EMBEDDED_ROOT = "jboss.embedded.root";

    private EmbeddedStandaloneServerFactory() {
    }

    public static StandaloneServer create(File jbossHomeDir, ModuleLoader moduleLoader, Properties systemProps, Map<String, String> systemEnv, String[] cmdargs) {
        if (jbossHomeDir == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("jbossHomeDir");
        }
        if (moduleLoader == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("moduleLoader");
        }
        if (systemProps == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("systemProps");
        }
        if (systemEnv == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("systemEnv");
        }
        if (cmdargs == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("cmdargs");
        }
        EmbeddedStandaloneServerFactory.setupCleanDirectories(jbossHomeDir.toPath(), systemProps);
        return new StandaloneServerImpl(cmdargs, systemProps, systemEnv, moduleLoader);
    }

    static void setupCleanDirectories(Path jbossHomeDir, Properties props) {
        Path tempRoot = EmbeddedStandaloneServerFactory.getTempRoot(props);
        if (tempRoot == null) {
            return;
        }
        File originalConfigDir = EmbeddedStandaloneServerFactory.getFileUnderAsRoot(jbossHomeDir.toFile(), props, "jboss.server.config.dir", "configuration", true);
        File originalDataDir = EmbeddedStandaloneServerFactory.getFileUnderAsRoot(jbossHomeDir.toFile(), props, "jboss.server.data.dir", "data", false);
        try {
            Path configDir = tempRoot.resolve("config");
            Files.createDirectory(configDir, new FileAttribute[0]);
            Path dataDir = tempRoot.resolve("data");
            Files.createDirectory(dataDir, new FileAttribute[0]);
            Path deploymentsDir = tempRoot.resolve("deployments");
            Files.createDirectory(deploymentsDir, new FileAttribute[0]);
            EmbeddedStandaloneServerFactory.copyDirectory(originalConfigDir, configDir.toFile());
            if (originalDataDir.exists()) {
                EmbeddedStandaloneServerFactory.copyDirectory(originalDataDir, dataDir.toFile());
            }
            props.put("jboss.server.base.dir", tempRoot.toAbsolutePath().toString());
            props.put("jboss.server.config.dir", configDir.toAbsolutePath().toString());
            props.put("jboss.server.data.dir", dataDir.toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotSetupEmbeddedServer(e);
        }
    }

    private static File getFileUnderAsRoot(File jbossHomeDir, Properties props, String propName, String relativeLocation, boolean mustExist) {
        String prop = props.getProperty(propName, null);
        if (prop == null) {
            prop = props.getProperty("jboss.server.base.dir", null);
            if (prop == null) {
                File dir = new File(jbossHomeDir, "standalone" + File.separator + relativeLocation);
                if (!(!mustExist || dir.exists() && dir.isDirectory())) {
                    throw ServerLogger.ROOT_LOGGER.embeddedServerDirectoryNotFound("standalone" + File.separator + relativeLocation, jbossHomeDir.getAbsolutePath());
                }
                return dir;
            }
            File server = new File(prop);
            EmbeddedStandaloneServerFactory.validateDirectory("jboss.server.base.dir", server);
            return new File(server, relativeLocation);
        }
        File dir = new File(prop);
        EmbeddedStandaloneServerFactory.validateDirectory("jboss.server.config.dir", dir);
        return dir;
    }

    private static Path getTempRoot(Properties props) {
        String tempRoot = props.getProperty(JBOSS_EMBEDDED_ROOT, null);
        if (tempRoot == null) {
            return null;
        }
        try {
            File root = new File(tempRoot);
            if (!root.exists()) {
                Files.createDirectories(root.toPath(), new FileAttribute[0]);
            }
            EmbeddedStandaloneServerFactory.validateDirectory("jboss.test.clean.root", root);
            return Files.createTempDirectory(root.toPath(), "configs", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotSetupEmbeddedServer(e);
        }
    }

    private static void validateDirectory(String property, File file) {
        if (!file.exists()) {
            throw ServerLogger.ROOT_LOGGER.propertySpecifiedFileDoesNotExist(property, file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw ServerLogger.ROOT_LOGGER.propertySpecifiedFileIsNotADirectory(property, file.getAbsolutePath());
        }
    }

    private static void copyDirectory(File src, File dest) {
        for (String current : src.list()) {
            File srcFile = new File(src, current);
            File destFile = new File(dest, current);
            try {
                Files.copy(srcFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                if (!srcFile.isDirectory()) continue;
                EmbeddedStandaloneServerFactory.copyDirectory(srcFile, destFile);
            }
            catch (IOException e) {
                throw ServerLogger.ROOT_LOGGER.errorCopyingFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath(), e);
            }
        }
    }

    private static class StandaloneServerImpl
    implements StandaloneServer {
        private final PropertyChangeListener processStateListener;
        private final String[] cmdargs;
        private final Properties systemProps;
        private final Map<String, String> systemEnv;
        private final ModuleLoader moduleLoader;
        private ServiceContainer serviceContainer;
        private ControlledProcessState.State currentProcessState;
        private ModelControllerClient modelControllerClient;
        private ExecutorService executorService;
        private ControlledProcessStateService controlledProcessStateService;
        private boolean uninstallStdIo;

        public StandaloneServerImpl(String[] cmdargs, Properties systemProps, Map<String, String> systemEnv, ModuleLoader moduleLoader) {
            this.cmdargs = cmdargs;
            this.systemProps = systemProps;
            this.systemEnv = systemEnv;
            this.moduleLoader = moduleLoader;
            this.processStateListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("currentState".equals(evt.getPropertyName())) {
                        ControlledProcessState.State newState = (ControlledProcessState.State)evt.getNewValue();
                        this.establishModelControllerClient(newState);
                    }
                }
            };
        }

        @Override
        public synchronized ModelControllerClient getModelControllerClient() {
            return this.modelControllerClient == null ? null : new DelegatingModelControllerClient(new DelegatingModelControllerClient.DelegateProvider(){

                public ModelControllerClient getDelegate() {
                    return this.getActiveModelControllerClient();
                }
            });
        }

        @Override
        public void start() throws EmbeddedProcessStartException {
            Bootstrap bootstrap = null;
            try {
                long startTime = System.currentTimeMillis();
                SystemExiter.initialize((SystemExiter.Exiter)new SystemExiter.Exiter(){

                    public void exit(int status) {
                        this.exit();
                    }
                });
                try {
                    StdioContext.install();
                    this.uninstallStdIo = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                ServerEnvironment serverEnvironment = Main.determineEnvironment((String[])this.cmdargs, (Properties)this.systemProps, this.systemEnv, (ServerEnvironment.LaunchType)ServerEnvironment.LaunchType.EMBEDDED, (long)startTime);
                bootstrap = Bootstrap.Factory.newInstance();
                Bootstrap.Configuration configuration = new Bootstrap.Configuration(serverEnvironment);
                configuration.setModuleLoader(this.moduleLoader);
                AsyncFuture future = bootstrap.startup(configuration, Collections.emptyList());
                this.serviceContainer = (ServiceContainer)future.get();
                this.executorService = Executors.newCachedThreadPool();
                ServiceController processStateServiceValue = this.serviceContainer.getRequiredService(ControlledProcessStateService.SERVICE_NAME);
                this.controlledProcessStateService = (ControlledProcessStateService)processStateServiceValue.getValue();
                this.controlledProcessStateService.addPropertyChangeListener(this.processStateListener);
                this.establishModelControllerClient(this.controlledProcessStateService.getCurrentState());
            }
            catch (RuntimeException rte) {
                if (bootstrap != null) {
                    bootstrap.failed();
                }
                throw rte;
            }
            catch (Exception ex) {
                if (bootstrap != null) {
                    bootstrap.failed();
                }
                throw EmbeddedLogger.ROOT_LOGGER.cannotStartEmbeddedServer(ex);
            }
        }

        @Override
        public void stop() {
            this.exit();
        }

        private void exit() {
            if (this.serviceContainer != null) {
                try {
                    this.serviceContainer.shutdown();
                    this.serviceContainer.awaitTermination();
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (InterruptedException ite) {
                    ite.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.controlledProcessStateService != null) {
                this.controlledProcessStateService.removePropertyChangeListener(this.processStateListener);
                this.controlledProcessStateService = null;
            }
            if (this.executorService != null) {
                try {
                    this.executorService.shutdown();
                    this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (InterruptedException ite) {
                    ite.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.uninstallStdIo) {
                try {
                    StdioContext.uninstall();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            SystemExiter.initialize((SystemExiter.Exiter)SystemExiter.Exiter.DEFAULT);
        }

        private synchronized void establishModelControllerClient(ControlledProcessState.State state) {
            ServiceController controllerService;
            ModelControllerClient newClient = null;
            if (state != ControlledProcessState.State.STOPPING && this.serviceContainer != null && (controllerService = this.serviceContainer.getService(Services.JBOSS_SERVER_CONTROLLER)) != null) {
                ModelController controller = (ModelController)controllerService.getValue();
                newClient = controller.createClient((Executor)this.executorService);
            }
            this.modelControllerClient = newClient;
            this.currentProcessState = state;
        }

        private synchronized ModelControllerClient getActiveModelControllerClient() {
            switch (this.currentProcessState) {
                case STOPPING: {
                    throw EmbeddedLogger.ROOT_LOGGER.processIsStopping();
                }
                case STARTING: {
                    if (this.modelControllerClient != null) break;
                    this.establishModelControllerClient(this.currentProcessState);
                    if (this.modelControllerClient != null) break;
                    throw EmbeddedLogger.ROOT_LOGGER.processIsReloading();
                }
            }
            return this.modelControllerClient;
        }
    }
}

