/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jacc;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.servlet.predicate.DispatcherTypePredicate;
import java.security.PrivilegedAction;
import javax.security.jacc.PolicyContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JACCContextIdHandler
implements HttpHandler {
    private final PrivilegedAction<String> setContextIdAction;
    private final HttpHandler next;

    public JACCContextIdHandler(String contextId, HttpHandler next) {
        this.setContextIdAction = new SetContextIDAction(contextId);
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String previousContextID = null;
        try {
            previousContextID = this.setContextID(this.setContextIdAction);
            this.next.handleRequest(exchange);
        }
        finally {
            this.setContextID(new SetContextIDAction(previousContextID));
        }
    }

    private String setContextID(PrivilegedAction<String> action) {
        if (WildFlySecurityManager.isChecking()) {
            return (String)WildFlySecurityManager.doUnchecked(action);
        }
        return action.run();
    }

    public static HandlerWrapper wrapper(final String contextId) {
        return new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                return new PredicateHandler(Predicates.or((Predicate[])new Predicate[]{DispatcherTypePredicate.REQUEST, DispatcherTypePredicate.ASYNC}), (HttpHandler)new JACCContextIdHandler(contextId, handler), handler);
            }
        };
    }

    private static class SetContextIDAction
    implements PrivilegedAction<String> {
        private final String contextID;

        SetContextIDAction(String contextID) {
            this.contextID = contextID;
        }

        @Override
        public String run() {
            String currentContextID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)this.contextID);
            return currentContextID;
        }
    }
}

