/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.util.HashMap;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.RealmsResource;

public class ClientsManagementService {
    protected static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    private RealmModel realm;
    private EventBuilder event;
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ClientConnection clientConnection;
    @Context
    protected Providers providers;
    @Context
    protected KeycloakSession session;

    public ClientsManagementService(RealmModel realm, EventBuilder event) {
        this.realm = realm;
        this.event = event;
    }

    public static UriBuilder clientsManagementBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path(RealmsResource.class, "getClientsManagementService");
    }

    public static UriBuilder registerNodeUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = ClientsManagementService.clientsManagementBaseUrl(baseUriBuilder);
        return uriBuilder.path(ClientsManagementService.class, "registerNode");
    }

    public static UriBuilder unregisterNodeUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = ClientsManagementService.clientsManagementBaseUrl(baseUriBuilder);
        return uriBuilder.path(ClientsManagementService.class, "unregisterNode");
    }

    @Path(value="register-node")
    @POST
    @Produces(value={"application/json"})
    public Response registerNode(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> formData) {
        if (!this.checkSsl()) {
            throw new ForbiddenException("HTTPS required");
        }
        this.event.event(EventType.REGISTER_NODE);
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            throw new UnauthorizedException("Realm not enabled");
        }
        ClientModel client = this.authorizeClient();
        String nodeHost = this.getClientClusterHost(formData);
        this.event.client(client).detail("node_host", nodeHost);
        logger.debugf("Registering cluster host '%s' for client '%s'", nodeHost, client.getClientId());
        client.registerNode(nodeHost, Time.currentTime());
        this.event.success();
        return Response.noContent().build();
    }

    @Path(value="unregister-node")
    @POST
    @Produces(value={"application/json"})
    public Response unregisterNode(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> formData) {
        if (!this.checkSsl()) {
            throw new ForbiddenException("HTTPS required");
        }
        this.event.event(EventType.UNREGISTER_NODE);
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            throw new UnauthorizedException("Realm not enabled");
        }
        ClientModel client = this.authorizeClient();
        String nodeHost = this.getClientClusterHost(formData);
        this.event.client(client).detail("node_host", nodeHost);
        logger.debugf("Unregistering cluster host '%s' for client '%s'", nodeHost, client.getClientId());
        client.unregisterNode(nodeHost);
        this.event.success();
        return Response.noContent().build();
    }

    protected ClientModel authorizeClient() {
        ClientModel client = AuthorizeClientUtil.authorizeClient(this.session, this.event).getClient();
        if (client.isPublicClient()) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Public clients not allowed");
            this.event.error("invalid_client");
            throw new BadRequestException("Public clients not allowed", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        return client;
    }

    protected String getClientClusterHost(MultivaluedMap<String, String> formData) {
        String clientClusterHost = (String)formData.getFirst((Object)"client_cluster_host");
        if (clientClusterHost == null || clientClusterHost.length() == 0) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "Client cluster host not specified");
            this.event.error("invalid_code");
            throw new BadRequestException("Cluster host not specified", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        return clientClusterHost;
    }

    private boolean checkSsl() {
        if (this.uriInfo.getBaseUri().getScheme().equals("https")) {
            return true;
        }
        return !this.realm.getSslRequired().isRequired(this.clientConnection);
    }
}

