/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.keycloak.messages.MessagesProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ServicesLogger;

@Provider
public class ModelExceptionMapper
implements ExceptionMapper<ModelException> {
    private static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    @Context
    private KeycloakSession session;

    public Response toResponse(ModelException ex) {
        String message = ((MessagesProvider)this.session.getProvider(MessagesProvider.class, "admin")).getMessage(ex.getMessage(), ex.getParameters());
        logger.error(message, ex);
        return ErrorResponse.error(message, Response.Status.BAD_REQUEST);
    }
}

