/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.Locale;
import java.util.Set;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CookieHelper;

public class LocaleHelper {
    private static final String LOCALE_COOKIE = "KEYCLOAK_LOCALE";
    private static final String UI_LOCALES_PARAM = "ui_locales";
    private static final String KC_LOCALE_PARAM = "kc_locale";

    public static Locale getLocale(KeycloakSession session, RealmModel realm, UserModel user) {
        if (!realm.isInternationalizationEnabled()) {
            return Locale.ENGLISH;
        }
        Locale locale = LocaleHelper.getUserLocale(session, realm, user);
        return locale != null ? locale : Locale.forLanguageTag(realm.getDefaultLocale());
    }

    private static Locale getUserLocale(KeycloakSession session, RealmModel realm, UserModel user) {
        Locale locale;
        String localeString;
        UriInfo uriInfo = session.getContext().getUri();
        HttpHeaders httpHeaders = session.getContext().getRequestHeaders();
        if (uriInfo != null && uriInfo.getQueryParameters().containsKey((Object)KC_LOCALE_PARAM)) {
            localeString = (String)uriInfo.getQueryParameters().getFirst((Object)KC_LOCALE_PARAM);
            locale = LocaleHelper.findLocale(realm.getSupportedLocales(), localeString);
            if (locale != null) {
                LocaleHelper.updateLocaleCookie(session, realm, localeString);
                if (user != null) {
                    LocaleHelper.updateUsersLocale(user, localeString);
                }
                return locale;
            }
        }
        if (httpHeaders != null && httpHeaders.getCookies().containsKey(LOCALE_COOKIE)) {
            localeString = ((Cookie)httpHeaders.getCookies().get(LOCALE_COOKIE)).getValue();
            locale = LocaleHelper.findLocale(realm.getSupportedLocales(), localeString);
            if (locale != null) {
                if (user != null) {
                    LocaleHelper.updateUsersLocale(user, localeString);
                }
                return locale;
            }
        }
        if (user != null && user.getAttributes().containsKey("locale")) {
            localeString = user.getFirstAttribute("locale");
            locale = LocaleHelper.findLocale(realm.getSupportedLocales(), localeString);
            if (locale != null) {
                LocaleHelper.updateLocaleCookie(session, realm, localeString);
                return locale;
            }
        }
        if (uriInfo != null && uriInfo.getQueryParameters().containsKey((Object)UI_LOCALES_PARAM)) {
            localeString = (String)uriInfo.getQueryParameters().getFirst((Object)UI_LOCALES_PARAM);
            locale = LocaleHelper.findLocale(realm.getSupportedLocales(), localeString.split(" "));
            if (locale != null) {
                return locale;
            }
        }
        if (httpHeaders != null && httpHeaders.getAcceptableLanguages() != null && !httpHeaders.getAcceptableLanguages().isEmpty()) {
            for (Locale l : httpHeaders.getAcceptableLanguages()) {
                String localeString2 = l.toLanguageTag();
                Locale locale2 = LocaleHelper.findLocale(realm.getSupportedLocales(), localeString2);
                if (locale2 == null) continue;
                return locale2;
            }
        }
        return null;
    }

    private static void updateLocaleCookie(KeycloakSession session, RealmModel realm, String locale) {
        boolean secure = realm.getSslRequired().isRequired(session.getContext().getUri().getRequestUri().getHost());
        CookieHelper.addCookie(LOCALE_COOKIE, locale, AuthenticationManager.getRealmCookiePath(realm, session.getContext().getUri()), null, null, -1, secure, true);
    }

    private static Locale findLocale(Set<String> supportedLocales, String ... localeStrings) {
        for (String localeString : localeStrings) {
            Locale result = null;
            Locale search = Locale.forLanguageTag(localeString);
            for (String languageTag : supportedLocales) {
                Locale locale = Locale.forLanguageTag(languageTag);
                if (!locale.getLanguage().equals(search.getLanguage())) continue;
                if (locale.getCountry().equals("") && result == null) {
                    result = locale;
                }
                if (!locale.getCountry().equals(search.getCountry())) continue;
                return locale;
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static void updateUsersLocale(UserModel user, String locale) {
        if (!locale.equals(user.getFirstAttribute("locale"))) {
            user.setSingleAttribute("locale", locale);
        }
    }
}

