/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyContainingAssertion;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.policy.model.EncryptedElements;
import org.apache.wss4j.policy.model.EncryptedParts;
import org.apache.wss4j.policy.model.SignedElements;
import org.apache.wss4j.policy.model.SignedParts;

public class SupportingTokens
extends AbstractSecurityAssertion
implements PolicyContainingAssertion {
    private QName supportingTokenType;
    private final List<AbstractToken> tokens = new ArrayList<AbstractToken>();
    private AlgorithmSuite algorithmSuite;
    private SignedParts signedParts;
    private SignedElements signedElements;
    private EncryptedParts encryptedParts;
    private EncryptedElements encryptedElements;
    private Policy nestedPolicy;

    public SupportingTokens(SPConstants.SPVersion version, QName supportingTokenType, Policy nestedPolicy) {
        super(version);
        this.supportingTokenType = supportingTokenType;
        this.nestedPolicy = nestedPolicy;
        this.parseNestedPolicy(nestedPolicy, this);
    }

    public QName getName() {
        return this.supportingTokenType;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        super.serialize(writer, this.getPolicy());
    }

    @Override
    public PolicyComponent normalize() {
        return super.normalize(this.getPolicy());
    }

    @Override
    protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
        return new SupportingTokens(this.getVersion(), this.getName(), nestedPolicy);
    }

    public Policy getPolicy() {
        return this.nestedPolicy;
    }

    protected void parseNestedPolicy(Policy nestedPolicy, SupportingTokens supportingTokens) {
        Iterator alternatives = nestedPolicy.getAlternatives();
        if (alternatives.hasNext()) {
            List assertions = (List)alternatives.next();
            for (int i = 0; i < assertions.size(); ++i) {
                Assertion assertion = (Assertion)assertions.get(i);
                String assertionName = assertion.getName().getLocalPart();
                String assertionNamespace = assertion.getName().getNamespaceURI();
                if (assertion instanceof AbstractToken) {
                    AbstractToken abstractToken = (AbstractToken)assertion;
                    supportingTokens.addToken(abstractToken);
                    abstractToken.setParentAssertion(supportingTokens);
                    continue;
                }
                if (this.getVersion().getSPConstants().getAlgorithmSuite().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getAlgorithmSuite().getNamespaceURI().equals(assertionNamespace)) {
                    if (supportingTokens.getAlgorithmSuite() != null) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    supportingTokens.setAlgorithmSuite((AlgorithmSuite)assertion);
                    continue;
                }
                if (this.getVersion().getSPConstants().getSignedParts().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getSignedParts().getNamespaceURI().equals(assertionNamespace)) {
                    if (supportingTokens.getSignedParts() != null) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    supportingTokens.setSignedParts((SignedParts)assertion);
                    continue;
                }
                if (this.getVersion().getSPConstants().getSignedElements().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getSignedElements().getNamespaceURI().equals(assertionNamespace)) {
                    if (supportingTokens.getSignedElements() != null) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    supportingTokens.setSignedElements((SignedElements)assertion);
                    continue;
                }
                if (this.getVersion().getSPConstants().getEncryptedParts().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getEncryptedParts().getNamespaceURI().equals(assertionNamespace)) {
                    if (supportingTokens.getEncryptedParts() != null) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    supportingTokens.setEncryptedParts((EncryptedParts)assertion);
                    continue;
                }
                if (!this.getVersion().getSPConstants().getEncryptedElements().getLocalPart().equals(assertionName) || !this.getVersion().getSPConstants().getEncryptedElements().getNamespaceURI().equals(assertionNamespace)) continue;
                if (supportingTokens.getEncryptedElements() != null) {
                    throw new IllegalArgumentException("Invalid Policy");
                }
                supportingTokens.setEncryptedElements((EncryptedElements)assertion);
            }
        }
    }

    public List<AbstractToken> getTokens() {
        return this.tokens;
    }

    public void addToken(AbstractToken token) {
        this.tokens.add(token);
    }

    public AlgorithmSuite getAlgorithmSuite() {
        return this.algorithmSuite;
    }

    protected void setAlgorithmSuite(AlgorithmSuite algorithmSuite) {
        this.algorithmSuite = algorithmSuite;
    }

    public SignedParts getSignedParts() {
        return this.signedParts;
    }

    protected void setSignedParts(SignedParts signedParts) {
        this.signedParts = signedParts;
    }

    public SignedElements getSignedElements() {
        return this.signedElements;
    }

    protected void setSignedElements(SignedElements signedElements) {
        this.signedElements = signedElements;
    }

    public EncryptedParts getEncryptedParts() {
        return this.encryptedParts;
    }

    protected void setEncryptedParts(EncryptedParts encryptedParts) {
        this.encryptedParts = encryptedParts;
    }

    public EncryptedElements getEncryptedElements() {
        return this.encryptedElements;
    }

    protected void setEncryptedElements(EncryptedElements encryptedElements) {
        this.encryptedElements = encryptedElements;
    }

    public boolean isEncryptedToken() {
        QName name = this.getName();
        return name != null && name.getLocalPart().contains("Encrypted");
    }

    public boolean isEndorsing() {
        QName name = this.getName();
        return name != null && name.getLocalPart().contains("Endorsing");
    }
}

