/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.CapturingXMLWriter;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMConfiguration;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RewindableInputStream;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.v200702.SequenceType;
import org.apache.cxf.ws.rm.v200702.TerminateSequenceType;

public class RMCaptureOutInterceptor
extends AbstractRMInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(RMCaptureOutInterceptor.class);

    public RMCaptureOutInterceptor() {
        super("pre-stream");
        this.addBefore(AttachmentOutInterceptor.class.getName());
        this.addBefore(LoggingOutInterceptor.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle(Message msg) throws SequenceFault, RMException {
        SourceSequence ss;
        Collection<SequenceAcknowledgement> acks;
        AddressingProperties maps = ContextUtils.retrieveMAPs((Message)msg, (boolean)false, (boolean)true, (boolean)false);
        if (null == maps) {
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"MAPS_RETRIEVAL_FAILURE_MSG");
            return;
        }
        if (Boolean.TRUE.equals(msg.get((Object)"org.apache.cxf.ws.rm.retransmitting"))) {
            return;
        }
        if (this.isRuntimeFault(msg)) {
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"RUNTIME_FAULT_MSG");
            Throwable cause = ((Exception)msg.getContent(Exception.class)).getCause();
            if (cause instanceof SequenceFault || cause instanceof RMException) {
                maps.getAction().setValue(this.getAddressingNamespace(maps) + "/fault");
            }
            return;
        }
        Source source = this.getManager().getSource(msg);
        RMConfiguration config = this.getManager().getEffectiveConfiguration(msg);
        String wsaNamespace = config.getAddressingNamespace();
        String rmNamespace = config.getRMNamespace();
        ProtocolVariation protocol = ProtocolVariation.findVariant(rmNamespace, wsaNamespace);
        RMContextUtils.setProtocolVariation(msg, protocol);
        maps.exposeAs(wsaNamespace);
        String action = null;
        if (null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action: " + action);
        }
        boolean isApplicationMessage = !RMContextUtils.isRMProtocolMessage(action);
        boolean isPartialResponse = MessageUtils.isPartialResponse((Message)msg);
        RMConstants constants = protocol.getConstants();
        boolean isLastMessage = "http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage".equals(action);
        RMProperties rmpsOut = RMContextUtils.retrieveRMProperties(msg, true);
        if (null == rmpsOut) {
            rmpsOut = new RMProperties();
            rmpsOut.exposeAs(protocol.getWSRMNamespace());
            RMContextUtils.storeRMProperties(msg, rmpsOut, true);
        }
        if (msg.getExchange().isOneWay()) {
            msg.getExchange().put((Object)"org.apache.cxf.transport.processOneWayResponse", (Object)true);
        }
        RMProperties rmpsIn = null;
        Identifier inSeqId = null;
        long inMessageNumber = 0L;
        if (isApplicationMessage) {
            rmpsIn = RMContextUtils.retrieveRMProperties(msg, false);
            if (null != rmpsIn && null != rmpsIn.getSequence()) {
                inSeqId = rmpsIn.getSequence().getIdentifier();
                inMessageNumber = rmpsIn.getSequence().getMessageNumber();
            }
            ContextUtils.storeDeferUncorrelatedMessageAbort((Message)msg);
        }
        Map invocationContext = (Map)msg.get((Object)"org.apache.cxf.invocation.context");
        if ((isApplicationMessage || isLastMessage && invocationContext != null) && !isPartialResponse) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("inbound sequence: " + (null == inSeqId ? "null" : inSeqId.getValue()));
            }
            Source source2 = source;
            synchronized (source2) {
                SourceSequence seq = null;
                seq = isLastMessage ? (SourceSequence)invocationContext.get(SourceSequence.class.getName()) : this.getManager().getSequence(inSeqId, msg, maps);
                assert (null != seq);
                seq.nextMessageNumber(inSeqId, inMessageNumber, isLastMessage);
                if (Boolean.TRUE.equals(msg.getContextualProperty("org.apache.cxf.ws.rm.last-message"))) {
                    seq.setLastMessage(true);
                }
                rmpsOut.setSequence(seq);
                if (seq.isLastMessage()) {
                    source.setCurrent(null);
                }
            }
        } else if (!MessageUtils.isRequestor((Message)msg) && constants.getCreateSequenceAction().equals(action)) {
            maps.getAction().setValue(constants.getCreateSequenceResponseAction());
        } else if (isPartialResponse && action == null && this.isResponseToAction(msg, constants.getSequenceAckAction()) && (acks = rmpsIn.getAcks()).size() == 1 && (ss = source.getSequence(acks.iterator().next().getIdentifier())) != null && ss.allAcknowledged()) {
            RMCaptureOutInterceptor.setAction(maps, constants.getTerminateSequenceAction());
            this.setTerminateSequence(msg, ss.getIdentifier(), protocol);
            msg.remove((Object)"org.apache.cxf.partial.response.empty");
            source.removeSequence(ss);
        }
        if (isApplicationMessage && !isPartialResponse) {
            this.getManager().initializeInterceptorChain(msg);
            this.captureMessage(msg);
        }
    }

    private void captureMessage(Message message) {
        message.put((Object)"org.apache.cxf.rm.capture", (Object)Boolean.TRUE);
        message.getInterceptorChain().add((Interceptor)new CaptureStart());
        message.getInterceptorChain().add((Interceptor)new CaptureEnd());
    }

    private String getAddressingNamespace(AddressingProperties maps) {
        String wsaNamespace = maps.getNamespaceURI();
        if (wsaNamespace == null) {
            this.getManager().getConfiguration().getAddressingNamespace();
        }
        return wsaNamespace;
    }

    boolean isRuntimeFault(Message message) {
        FaultMode mode = MessageUtils.getFaultMode((Message)message);
        if (null == mode) {
            return false;
        }
        return FaultMode.CHECKED_APPLICATION_FAULT != mode;
    }

    private boolean isResponseToAction(Message msg, String action) {
        AddressingProperties inMaps = RMContextUtils.retrieveMAPs(msg, false, false);
        String inAction = null;
        if (null != inMaps.getAction()) {
            inAction = inMaps.getAction().getValue();
        }
        return action.equals(inAction);
    }

    private void setTerminateSequence(Message msg, Identifier identifier, ProtocolVariation protocol) throws RMException {
        TerminateSequenceType ts = new TerminateSequenceType();
        ts.setIdentifier(identifier);
        MessageContentsList contents = new MessageContentsList(new Object[]{protocol.getCodec().convertToSend(ts)});
        msg.setContent(List.class, (Object)contents);
        ExchangeImpl newex = new ExchangeImpl();
        Exchange oldex = msg.getExchange();
        newex.put(Bus.class, (Object)oldex.getBus());
        newex.put(Endpoint.class, (Object)oldex.getEndpoint());
        newex.put(Service.class, (Object)oldex.getEndpoint().getService());
        newex.put(Binding.class, (Object)oldex.getEndpoint().getBinding());
        newex.setConduit(oldex.getConduit(msg));
        newex.setDestination(oldex.getDestination());
        RMEndpoint rmep = this.getManager().getReliableEndpoint(msg);
        OperationInfo oi = rmep.getEndpoint(protocol).getEndpointInfo().getService().getInterface().getOperation(protocol.getConstants().getTerminateSequenceAnonymousOperationName());
        BindingInfo bi = rmep.getBindingInfo(protocol);
        BindingOperationInfo boi = bi.getOperation(oi);
        newex.put(BindingInfo.class, (Object)bi);
        newex.put(BindingOperationInfo.class, (Object)boi);
        msg.setExchange((Exchange)newex);
        newex.setOutMessage(msg);
    }

    private static void setAction(AddressingProperties maps, String action) {
        AttributedURIType actionURI = new AttributedURIType();
        actionURI.setValue(action);
        maps.setAction(actionURI);
    }

    private class CaptureEnd
    extends AbstractPhaseInterceptor<Message> {
        CaptureEnd() {
            super("write-ending");
            this.addAfter(SoapOutInterceptor.SoapOutEndingInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            XMLStreamWriter w = (XMLStreamWriter)message.get((Object)"RM_ORIGINAL_WRITER");
            message.setContent(XMLStreamWriter.class, (Object)w);
            CapturingXMLWriter cw = (CapturingXMLWriter)message.get((Object)"RM_CAPTURING_WRITER");
            try {
                RMProperties rmps = RMContextUtils.retrieveRMProperties(message, true);
                SequenceType sequence = rmps.getSequence();
                Long number = sequence.getMessageNumber();
                Identifier sid = sequence.getIdentifier();
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "Captured message " + number + " in sequence " + sid.getValue());
                }
                ByteArrayInputStream bis = cw.getOutputStream().createInputStream();
                message.put((Object)"org.apache.cxf.ws.rm.content", (Object)RewindableInputStream.makeRewindable(bis));
                RMManager manager = RMCaptureOutInterceptor.this.getManager();
                manager.getRetransmissionQueue().start();
                manager.getRetransmissionQueue().addUnacknowledged(message);
                RMStore store = manager.getStore();
                if (null != store) {
                    AddressingProperties maps;
                    Source s = manager.getSource(message);
                    SourceSequence ss = s.getSequence(sid);
                    RMMessage msg = new RMMessage();
                    msg.setMessageNumber(number);
                    if (!MessageUtils.isRequestor((Message)message) && null != (maps = RMContextUtils.retrieveMAPs(message, false, true)) && null != maps.getTo()) {
                        msg.setTo(maps.getTo().getValue());
                    }
                    msg.setContent(bis);
                    store.persistOutgoing(ss, msg);
                }
            }
            catch (RMException e) {
            }
            catch (XMLStreamException e) {
                LOG.log(Level.SEVERE, "Error persisting message", e);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Error persisting message", e);
            }
            if (cw.getThrowable() != null) {
                Throwable t = cw.getThrowable();
                RuntimeException exception = null;
                exception = t instanceof RuntimeException ? (RuntimeException)t : new Fault(t);
                throw exception;
            }
        }
    }

    private class CaptureStart
    extends AbstractPhaseInterceptor<Message> {
        CaptureStart() {
            super("pre-protocol");
        }

        public void handleMessage(Message message) throws Fault {
            XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
            message.put((Object)"RM_ORIGINAL_WRITER", (Object)writer);
            writer = new CapturingXMLWriter(writer);
            message.put((Object)"RM_CAPTURING_WRITER", (Object)writer);
            message.setContent(XMLStreamWriter.class, (Object)writer);
            message.put((Object)"disable.outputstream.optimization", (Object)Boolean.TRUE);
        }
    }
}

