/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveredTransaction;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.io.IOException;
import java.util.Date;
import org.omg.CosTransactions.Status;

public class AssumedCompleteTransaction
extends RecoveredTransaction {
    private Date _lastActiveTime;
    private static String ourTypeName = "/StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple/AssumedCompleteTransaction";

    public AssumedCompleteTransaction(Uid actionUid) {
        super(actionUid, ourTypeName);
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("AssumedCompleteTransaction " + this.get_uid() + " created"));
        }
    }

    @Override
    public Status getOriginalStatus() {
        return Status.StatusNoTransaction;
    }

    @Override
    public String type() {
        return AssumedCompleteTransaction.typeName();
    }

    public static String typeName() {
        return ourTypeName;
    }

    @Override
    public String toString() {
        return "AssumedCompleteTransaction < " + this.get_uid() + " >";
    }

    @Override
    public boolean assumeComplete() {
        return false;
    }

    @Override
    public Date getLastActiveTime() {
        return this._lastActiveTime;
    }

    @Override
    public boolean restore_state(InputObjectState objectState, int ot) {
        boolean result = super.restore_state(objectState, ot);
        if (result) {
            try {
                long oldtime = objectState.unpackLong();
                this._lastActiveTime = new Date(oldtime);
            }
            catch (IOException ex) {
                this._lastActiveTime = new Date();
            }
        }
        return result;
    }

    @Override
    public boolean save_state(OutputObjectState os, int ot) {
        boolean result = super.save_state(os, ot);
        if (result) {
            this._lastActiveTime = new Date();
            try {
                os.packLong(this._lastActiveTime.getTime());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }
}

