/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.TimerServiceRegistry;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.NonFunctionalTimerService;
import org.jboss.as.ejb3.timerservice.TimedObjectInvokerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceMetaData;
import org.jboss.as.ejb3.timerservice.persistence.TimerPersistence;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.EjbDeploymentMarker;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class TimerServiceDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final ServiceName TIMER_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "timer"});
    private final ServiceName timerServiceThreadPool;
    private final String defaultTimerDataStore;

    public TimerServiceDeploymentProcessor(ServiceName timerServiceThreadPool, String defaultTimerDataStore) {
        this.timerServiceThreadPool = timerServiceThreadPool;
        this.defaultTimerDataStore = defaultTimerDataStore;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List timerService;
        TimerServiceRegistry timerServiceRegistry;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        final Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        ServiceName defaultTimerPersistenceService = TimerPersistence.SERVICE_NAME.append(new String[]{this.defaultTimerDataStore});
        final HashMap<String, ServiceName> timerPersistenceServices = new HashMap<String, ServiceName>();
        TimerServiceRegistry timerServiceRegistry2 = timerServiceRegistry = EjbDeploymentMarker.isEjbDeployment((DeploymentUnit)deploymentUnit) ? new TimerServiceRegistry() : null;
        if (ejbJarMetaData != null && ejbJarMetaData.getAssemblyDescriptor() != null && (timerService = ejbJarMetaData.getAssemblyDescriptor().getAny(TimerServiceMetaData.class)) != null) {
            for (TimerServiceMetaData data : timerService) {
                if (data.getEjbName().equals("*")) {
                    defaultTimerPersistenceService = TimerPersistence.SERVICE_NAME.append(new String[]{data.getDataStoreName()});
                    continue;
                }
                timerPersistenceServices.put(data.getEjbName(), TimerPersistence.SERVICE_NAME.append(new String[]{data.getDataStoreName()}));
            }
        }
        final ServiceName finalDefaultTimerPersistenceService = defaultTimerPersistenceService;
        for (final ComponentDescription componentDescription : moduleDescription.getComponentDescriptions()) {
            if (!componentDescription.isTimerServiceApplicable()) continue;
            if (componentDescription.isTimerServiceRequired()) {
                final String deploymentName = moduleDescription.getDistinctName() == null || moduleDescription.getDistinctName().length() == 0 ? moduleDescription.getApplicationName() + "." + moduleDescription.getModuleName() : moduleDescription.getApplicationName() + "." + moduleDescription.getModuleName() + "." + moduleDescription.getDistinctName();
                EjbLogger.ROOT_LOGGER.debugf("Installing timer service for component %s", componentDescription.getComponentName());
                componentDescription.getConfigurators().add(new ComponentConfigurator(){

                    public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)description;
                        ServiceName invokerServiceName = ejbComponentDescription.getServiceName().append(TimedObjectInvokerImpl.SERVICE_NAME);
                        TimedObjectInvokerImpl invoker = new TimedObjectInvokerImpl(deploymentName, module);
                        context.getServiceTarget().addService(invokerServiceName, (Service)invoker).addDependency(componentDescription.getCreateServiceName(), EJBComponent.class, invoker.getEjbComponent()).install();
                        final ServiceName serviceName = componentDescription.getServiceName().append(TimerServiceImpl.SERVICE_NAME);
                        TimerServiceImpl service = new TimerServiceImpl(ejbComponentDescription.getScheduleMethods(), serviceName, timerServiceRegistry);
                        ServiceBuilder createBuilder = context.getServiceTarget().addService(serviceName, (Service)service);
                        createBuilder.addDependency(TIMER_SERVICE_NAME, Timer.class, service.getTimerInjectedValue());
                        createBuilder.addDependency(componentDescription.getCreateServiceName(), EJBComponent.class, service.getEjbComponentInjectedValue());
                        createBuilder.addDependency(TimerServiceDeploymentProcessor.this.timerServiceThreadPool, ExecutorService.class, service.getExecutorServiceInjectedValue());
                        if (timerPersistenceServices.containsKey(ejbComponentDescription.getEJBName())) {
                            createBuilder.addDependency((ServiceName)timerPersistenceServices.get(ejbComponentDescription.getEJBName()), TimerPersistence.class, service.getTimerPersistence());
                        } else {
                            createBuilder.addDependency(finalDefaultTimerPersistenceService, TimerPersistence.class, service.getTimerPersistence());
                        }
                        createBuilder.addDependency(invokerServiceName, TimedObjectInvoker.class, service.getTimedObjectInvoker());
                        createBuilder.install();
                        ejbComponentDescription.setTimerService(service);
                        configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

                            public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                                serviceBuilder.addDependency(serviceName);
                            }
                        });
                    }
                });
                continue;
            }
            componentDescription.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)description;
                    final ServiceName nonFunctionalTimerServiceName = NonFunctionalTimerService.serviceNameFor(ejbComponentDescription);
                    NonFunctionalTimerService nonFunctionalTimerService = ejbComponentDescription instanceof StatefulComponentDescription ? new NonFunctionalTimerService(EjbLogger.ROOT_LOGGER.timerServiceMethodNotAllowedForSFSB(ejbComponentDescription.getComponentName()), timerServiceRegistry) : new NonFunctionalTimerService(EjbLogger.ROOT_LOGGER.ejbHasNoTimerMethods(), timerServiceRegistry);
                    context.getServiceTarget().addService(nonFunctionalTimerServiceName, (Service)nonFunctionalTimerService).install();
                    ejbComponentDescription.setTimerService(nonFunctionalTimerService);
                    configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

                        public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                            serviceBuilder.addDependency(nonFunctionalTimerServiceName);
                        }
                    });
                }
            });
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

