/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.attachment.Rfc5987Util;

public class ContentDisposition {
    private static final String CD_HEADER_PARAMS_EXPRESSION = "(([\\w]+( )?\\*?=( )?\"[^\"]+\")|([\\w]+( )?\\*?=( )?[^;]+))";
    private static final Pattern CD_HEADER_PARAMS_PATTERN = Pattern.compile("(([\\w]+( )?\\*?=( )?\"[^\"]+\")|([\\w]+( )?\\*?=( )?[^;]+))");
    private static final String CD_HEADER_EXT_PARAMS_EXPRESSION = "(UTF-8|ISO-8859-1)''((?:%[0-9a-f]{2}|\\S)+)";
    private static final Pattern CD_HEADER_EXT_PARAMS_PATTERN = Pattern.compile("(UTF-8|ISO-8859-1)''((?:%[0-9a-f]{2}|\\S)+)");
    private String value;
    private String type;
    private Map<String, String> params = new LinkedHashMap<String, String>();

    public ContentDisposition(String value) {
        this.value = value;
        String tempValue = value;
        int index = tempValue.indexOf(59);
        if (index > 0 && tempValue.indexOf(61) >= index) {
            this.type = tempValue.substring(0, index).trim();
            tempValue = tempValue.substring(index + 1);
        }
        String extendedFilename = null;
        Matcher m = CD_HEADER_PARAMS_PATTERN.matcher(tempValue);
        while (m.find()) {
            String paramValue;
            String[] pair = m.group().trim().split("=");
            String paramName = pair[0].trim();
            String string = paramValue = pair.length == 2 ? pair[1].trim().replace("\"", "") : "";
            if ("filename*".equals(paramName)) {
                try {
                    Matcher matcher = CD_HEADER_EXT_PARAMS_PATTERN.matcher(paramValue);
                    if (matcher.matches()) {
                        String encodingScheme = matcher.group(1);
                        String encodedValue = matcher.group(2);
                        extendedFilename = paramValue = Rfc5987Util.decode(encodedValue, encodingScheme);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            this.params.put(paramName, paramValue);
        }
        if (extendedFilename != null) {
            this.params.put("filename", extendedFilename);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getParameter(String name) {
        return this.params.get(name);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.params);
    }

    public String toString() {
        return this.value;
    }
}

