/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.mapreduce;

import java.io.Serializable;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.Mapper;
import org.keycloak.models.sessions.infinispan.entities.ClientInitialAccessEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class ClientInitialAccessMapper
implements Mapper<String, SessionEntity, String, Object>,
Serializable {
    private String realm;
    private EmitValue emit = EmitValue.ENTITY;
    private Integer expired;

    public ClientInitialAccessMapper(String realm) {
        this.realm = realm;
    }

    public static ClientInitialAccessMapper create(String realm) {
        return new ClientInitialAccessMapper(realm);
    }

    public ClientInitialAccessMapper emitKey() {
        this.emit = EmitValue.KEY;
        return this;
    }

    public ClientInitialAccessMapper expired(int time) {
        this.expired = time;
        return this;
    }

    public void map(String key, SessionEntity e, Collector collector) {
        if (!this.realm.equals(e.getRealm())) {
            return;
        }
        if (!(e instanceof ClientInitialAccessEntity)) {
            return;
        }
        ClientInitialAccessEntity entity = (ClientInitialAccessEntity)e;
        boolean include = false;
        if (this.expired != null) {
            if (entity.getRemainingCount() <= 0) {
                include = true;
            } else if (entity.getExpiration() > 0 && entity.getTimestamp() + entity.getExpiration() < this.expired) {
                include = true;
            }
        } else {
            include = true;
        }
        if (include) {
            switch (this.emit) {
                case KEY: {
                    collector.emit((Object)key, (Object)key);
                    break;
                }
                case ENTITY: {
                    collector.emit((Object)key, (Object)entity);
                }
            }
        }
    }

    private static enum EmitValue {
        KEY,
        ENTITY;

    }
}

