/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.lock;

import java.sql.Connection;
import java.sql.SQLException;
import liquibase.Liquibase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProviderFactory;
import org.keycloak.connections.jpa.updater.liquibase.conn.LiquibaseConnectionProvider;
import org.keycloak.connections.jpa.updater.liquibase.lock.CustomLockService;
import org.keycloak.connections.jpa.updater.liquibase.lock.LiquibaseDBLockProviderFactory;
import org.keycloak.connections.jpa.updater.liquibase.lock.LockRetryException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.dblock.DBLockProvider;

public class LiquibaseDBLockProvider
implements DBLockProvider {
    private static final Logger logger = Logger.getLogger(LiquibaseDBLockProvider.class);
    private int DEFAULT_MAX_ATTEMPTS;
    private final LiquibaseDBLockProviderFactory factory;
    private final KeycloakSession session;
    private CustomLockService lockService;
    private Connection dbConnection;
    private int maxAttempts;

    public LiquibaseDBLockProvider(LiquibaseDBLockProviderFactory factory, KeycloakSession session) {
        this.maxAttempts = this.DEFAULT_MAX_ATTEMPTS = 3;
        this.factory = factory;
        this.session = session;
        this.init();
    }

    private void init() {
        LiquibaseConnectionProvider liquibaseProvider = (LiquibaseConnectionProvider)this.session.getProvider(LiquibaseConnectionProvider.class);
        JpaConnectionProviderFactory jpaProviderFactory = (JpaConnectionProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(JpaConnectionProvider.class);
        this.dbConnection = jpaProviderFactory.getConnection();
        String defaultSchema = jpaProviderFactory.getSchema();
        try {
            Liquibase liquibase = liquibaseProvider.getLiquibase(this.dbConnection, defaultSchema);
            this.lockService = new CustomLockService();
            this.lockService.setChangeLogLockWaitTime(this.factory.getLockWaitTimeoutMillis());
            this.lockService.setDatabase(liquibase.getDatabase());
        }
        catch (LiquibaseException exception) {
            this.safeRollbackConnection();
            this.safeCloseConnection();
            throw new IllegalStateException(exception);
        }
    }

    private void restart() {
        this.safeCloseConnection();
        this.dbConnection = null;
        this.lockService = null;
        this.init();
    }

    public void waitForLock() {
        while (this.maxAttempts > 0) {
            try {
                this.lockService.waitForLock();
                this.maxAttempts = this.DEFAULT_MAX_ATTEMPTS;
                return;
            }
            catch (LockRetryException le) {
                this.safeRollbackConnection();
                this.restart();
                --this.maxAttempts;
            }
            catch (RuntimeException re) {
                this.safeRollbackConnection();
                this.safeCloseConnection();
                throw re;
            }
        }
    }

    public void releaseLock() {
        this.lockService.releaseLock();
        this.lockService.reset();
    }

    public boolean supportsForcedUnlock() {
        return false;
    }

    public void destroyLockInfo() {
        try {
            this.lockService.destroy();
            this.dbConnection.commit();
            logger.debug((Object)"Destroyed lock table");
        }
        catch (SQLException | DatabaseException de) {
            logger.error((Object)"Failed to destroy lock table");
            this.safeRollbackConnection();
        }
    }

    public void close() {
        this.safeCloseConnection();
    }

    private void safeRollbackConnection() {
        if (this.dbConnection != null) {
            try {
                this.dbConnection.rollback();
            }
            catch (SQLException se) {
                logger.warn((Object)"Failed to rollback connection after error", (Throwable)se);
            }
        }
    }

    private void safeCloseConnection() {
        if (this.dbConnection != null) {
            try {
                this.dbConnection.close();
            }
            catch (SQLException e) {
                logger.warn((Object)"Failed to close connection", (Throwable)e);
            }
        }
    }
}

