/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.util.ArrayList;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.provider.AttributeStatementProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.sts.provider.model.secext.UsernameTokenType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.SAMLTokenPrincipalImpl;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.AttributeBean;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;
import org.w3c.dom.Element;

public class DefaultAttributeStatementProvider
implements AttributeStatementProvider {
    @Override
    public AttributeStatementBean getStatement(TokenProviderParameters providerParameters) {
        AttributeStatementBean attrBean = new AttributeStatementBean();
        ArrayList<AttributeBean> attributeList = new ArrayList<AttributeBean>();
        TokenRequirements tokenRequirements = providerParameters.getTokenRequirements();
        String tokenType = tokenRequirements.getTokenType();
        AttributeBean attributeBean = this.createDefaultAttribute(tokenType);
        attributeList.add(attributeBean);
        ReceivedToken actAs = tokenRequirements.getActAs();
        try {
            AttributeBean parameterBean;
            if (actAs != null && !(parameterBean = this.handleAdditionalParameters(actAs.getToken(), tokenType)).getAttributeValues().isEmpty()) {
                attributeList.add(parameterBean);
            }
        }
        catch (WSSecurityException ex) {
            throw new STSException(ex.getMessage(), (Throwable)ex);
        }
        attrBean.setSamlAttributes(attributeList);
        return attrBean;
    }

    private AttributeBean createDefaultAttribute(String tokenType) {
        AttributeBean attributeBean = new AttributeBean();
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType)) {
            attributeBean.setSimpleName("token-requestor");
            attributeBean.setQualifiedName("http://cxf.apache.org/sts");
        } else {
            attributeBean.setQualifiedName("token-requestor");
            attributeBean.setNameFormat("http://cxf.apache.org/sts");
        }
        attributeBean.addAttributeValue((Object)"authenticated");
        return attributeBean;
    }

    private AttributeBean handleAdditionalParameters(Object parameter, String tokenType) throws WSSecurityException {
        AttributeBean parameterBean = new AttributeBean();
        String claimType = "ActAs";
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType)) {
            parameterBean.setSimpleName(claimType);
            parameterBean.setQualifiedName("http://cxf.apache.org/sts");
        } else {
            parameterBean.setQualifiedName(claimType);
            parameterBean.setNameFormat("http://cxf.apache.org/sts");
        }
        if (parameter instanceof UsernameTokenType) {
            parameterBean.addAttributeValue((Object)((UsernameTokenType)parameter).getUsername().getValue());
        } else if (parameter instanceof Element) {
            SamlAssertionWrapper wrapper = new SamlAssertionWrapper((Element)parameter);
            SAMLTokenPrincipalImpl principal = new SAMLTokenPrincipalImpl(wrapper);
            parameterBean.addAttributeValue((Object)principal.getName());
        }
        return parameterBean;
    }
}

