/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml;

import java.net.URI;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Document;

public class SAML2LogoutRequestBuilder {
    protected String userPrincipal;
    protected String userPrincipalFormat;
    protected String sessionIndex;
    protected long assertionExpiration;
    protected String destination;
    protected String issuer;

    public SAML2LogoutRequestBuilder destination(String destination) {
        this.destination = destination;
        return this;
    }

    public SAML2LogoutRequestBuilder issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public SAML2LogoutRequestBuilder assertionExpiration(int assertionExpiration) {
        this.assertionExpiration = assertionExpiration;
        return this;
    }

    public SAML2LogoutRequestBuilder userPrincipal(String nameID, String nameIDformat) {
        this.userPrincipal = nameID;
        this.userPrincipalFormat = nameIDformat;
        return this;
    }

    public SAML2LogoutRequestBuilder sessionIndex(String index) {
        this.sessionIndex = index;
        return this;
    }

    public Document buildDocument() throws ProcessingException, ConfigurationException, ParsingException {
        Document document = new SAML2Request().convert((RequestAbstractType)this.createLogoutRequest());
        return document;
    }

    private LogoutRequestType createLogoutRequest() throws ConfigurationException {
        LogoutRequestType lort = new SAML2Request().createLogoutRequest(this.issuer);
        NameIDType nameID = new NameIDType();
        nameID.setValue(this.userPrincipal);
        String nameIDFormat = this.userPrincipalFormat;
        nameID.setFormat(URI.create(nameIDFormat));
        lort.setNameID(nameID);
        if (this.issuer != null) {
            NameIDType issuerID = new NameIDType();
            issuerID.setValue(this.issuer);
            lort.setIssuer(issuerID);
        }
        if (this.sessionIndex != null) {
            lort.addSessionIndex(this.sessionIndex);
        }
        if (this.assertionExpiration > 0L) {
            lort.setNotOnOrAfter(XMLTimeUtil.add(lort.getIssueInstant(), this.assertionExpiration * 1000L));
        }
        lort.setDestination(URI.create(this.destination));
        return lort;
    }
}

