/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormAuthenticator;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigInfoRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.utils.CredentialHelper;

public class AuthenticationManagementResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private RealmAuth auth;
    private AdminEventBuilder adminEvent;
    @Context
    private UriInfo uriInfo;
    private static ServicesLogger logger = ServicesLogger.ROOT_LOGGER;

    public AuthenticationManagementResource(RealmModel realm, KeycloakSession session, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.auth.init(RealmAuth.Resource.REALM);
        this.adminEvent = adminEvent;
    }

    @Path(value="/form-providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getFormProviders() {
        this.auth.requireView();
        List factories = this.session.getKeycloakSessionFactory().getProviderFactories(FormAuthenticator.class);
        return this.buildProviderMetadata(factories);
    }

    @Path(value="/authenticator-providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getAuthenticatorProviders() {
        this.auth.requireView();
        List factories = this.session.getKeycloakSessionFactory().getProviderFactories(Authenticator.class);
        return this.buildProviderMetadata(factories);
    }

    @Path(value="/client-authenticator-providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getClientAuthenticatorProviders() {
        this.auth.requireAny();
        List factories = this.session.getKeycloakSessionFactory().getProviderFactories(ClientAuthenticator.class);
        return this.buildProviderMetadata(factories);
    }

    public List<Map<String, Object>> buildProviderMetadata(List<ProviderFactory> factories) {
        LinkedList<Map<String, Object>> providers = new LinkedList<Map<String, Object>>();
        for (ProviderFactory factory : factories) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", factory.getId());
            ConfigurableAuthenticatorFactory configured = (ConfigurableAuthenticatorFactory)factory;
            data.put("description", configured.getHelpText());
            data.put("displayName", configured.getDisplayType());
            providers.add(data);
        }
        return providers;
    }

    @Path(value="/form-action-providers")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getFormActionProviders() {
        this.auth.requireView();
        List factories = this.session.getKeycloakSessionFactory().getProviderFactories(FormAction.class);
        return this.buildProviderMetadata(factories);
    }

    @Path(value="/flows")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<AuthenticationFlowRepresentation> getFlows() {
        this.auth.requireAny();
        LinkedList<AuthenticationFlowRepresentation> flows = new LinkedList<AuthenticationFlowRepresentation>();
        for (AuthenticationFlowModel flow : this.realm.getAuthenticationFlows()) {
            if (!flow.isTopLevel()) continue;
            flows.add(ModelToRepresentation.toRepresentation((RealmModel)this.realm, (AuthenticationFlowModel)flow));
        }
        return flows;
    }

    @Path(value="/flows")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response createFlow(AuthenticationFlowRepresentation flow) {
        this.auth.requireManage();
        if (flow.getAlias() == null || flow.getAlias().isEmpty()) {
            return ErrorResponse.exists("Failed to create flow with empty alias name");
        }
        if (this.realm.getFlowByAlias(flow.getAlias()) != null) {
            return ErrorResponse.exists("Flow " + flow.getAlias() + " already exists");
        }
        this.realm.addAuthenticationFlow(RepresentationToModel.toModel((AuthenticationFlowRepresentation)flow));
        return Response.status((int)201).build();
    }

    @Path(value="/flows/{id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public AuthenticationFlowRepresentation getFlow(@PathParam(value="id") String id) {
        this.auth.requireView();
        AuthenticationFlowModel flow = this.realm.getAuthenticationFlowById(id);
        if (flow == null) {
            throw new NotFoundException("Could not find flow with id");
        }
        return ModelToRepresentation.toRepresentation((RealmModel)this.realm, (AuthenticationFlowModel)flow);
    }

    @Path(value="/flows/{id}")
    @DELETE
    @NoCache
    public void deleteFlow(@PathParam(value="id") String id) {
        this.auth.requireManage();
        AuthenticationFlowModel flow = this.realm.getAuthenticationFlowById(id);
        if (flow == null) {
            throw new NotFoundException("Could not find flow with id");
        }
        if (flow.isBuiltIn()) {
            throw new BadRequestException("Can't delete built in flow");
        }
        List executions = this.realm.getAuthenticationExecutions(id);
        for (AuthenticationExecutionModel execution : executions) {
            if (execution.getFlowId() != null) {
                AuthenticationFlowModel nonTopLevelFlow = this.realm.getAuthenticationFlowById(execution.getFlowId());
                this.realm.removeAuthenticationFlow(nonTopLevelFlow);
            }
            this.realm.removeAuthenticatorExecution(execution);
        }
        this.realm.removeAuthenticationFlow(flow);
    }

    @Path(value="/flows/{flowAlias}/copy")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response copy(@PathParam(value="flowAlias") String flowAlias, Map<String, String> data) {
        this.auth.requireManage();
        String newName = data.get("newName");
        if (this.realm.getFlowByAlias(newName) != null) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        AuthenticationFlowModel flow = this.realm.getFlowByAlias(flowAlias);
        if (flow == null) {
            logger.debug("flow not found: " + flowAlias);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        AuthenticationFlowModel copy = new AuthenticationFlowModel();
        copy.setAlias(newName);
        copy.setDescription(flow.getDescription());
        copy.setProviderId(flow.getProviderId());
        copy.setBuiltIn(false);
        copy.setTopLevel(flow.isTopLevel());
        copy = this.realm.addAuthenticationFlow(copy);
        this.copy(newName, flow, copy);
        return Response.status((int)201).build();
    }

    protected void copy(String newName, AuthenticationFlowModel from, AuthenticationFlowModel to) {
        for (AuthenticationExecutionModel execution : this.realm.getAuthenticationExecutions(from.getId())) {
            if (execution.isAuthenticatorFlow()) {
                AuthenticationFlowModel subFlow = this.realm.getAuthenticationFlowById(execution.getFlowId());
                AuthenticationFlowModel copy = new AuthenticationFlowModel();
                copy.setAlias(newName + " " + subFlow.getAlias());
                copy.setDescription(subFlow.getDescription());
                copy.setProviderId(subFlow.getProviderId());
                copy.setBuiltIn(false);
                copy.setTopLevel(false);
                copy = this.realm.addAuthenticationFlow(copy);
                execution.setFlowId(copy.getId());
                this.copy(newName, subFlow, copy);
            }
            execution.setId(null);
            execution.setParentFlow(to.getId());
            this.realm.addAuthenticatorExecution(execution);
        }
    }

    @Path(value="/flows/{flowAlias}/executions/flow")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public void addExecutionFlow(@PathParam(value="flowAlias") String flowAlias, Map<String, String> data) {
        this.auth.requireManage();
        AuthenticationFlowModel parentFlow = this.realm.getFlowByAlias(flowAlias);
        if (parentFlow == null) {
            throw new BadRequestException("Parent flow doesn't exists");
        }
        String alias = data.get("alias");
        String type = data.get("type");
        String provider = data.get("provider");
        String description = data.get("description");
        AuthenticationFlowModel newFlow = this.realm.getFlowByAlias(alias);
        if (newFlow != null) {
            throw new BadRequestException("New flow alias name already exists");
        }
        newFlow = new AuthenticationFlowModel();
        newFlow.setAlias(alias);
        newFlow.setDescription(description);
        newFlow.setProviderId(type);
        newFlow = this.realm.addAuthenticationFlow(newFlow);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlow.getId());
        execution.setFlowId(newFlow.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED);
        execution.setAuthenticatorFlow(true);
        execution.setAuthenticator(provider);
        execution.setPriority(this.getNextPriority(parentFlow));
        this.realm.addAuthenticatorExecution(execution);
    }

    private int getNextPriority(AuthenticationFlowModel parentFlow) {
        List<AuthenticationExecutionModel> executions = this.getSortedExecutions(parentFlow);
        return executions.isEmpty() ? 0 : executions.get(executions.size() - 1).getPriority() + 1;
    }

    @Path(value="/flows/{flowAlias}/executions/execution")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public void addExecution(@PathParam(value="flowAlias") String flowAlias, Map<String, String> data) {
        this.auth.requireManage();
        AuthenticationFlowModel parentFlow = this.realm.getFlowByAlias(flowAlias);
        if (parentFlow == null) {
            throw new BadRequestException("Parent flow doesn't exists");
        }
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to add execution to a built in flow");
        }
        String provider = data.get("provider");
        ProviderFactory f = parentFlow.getProviderId().equals("client-flow") ? this.session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, provider) : (parentFlow.getProviderId().equals("form-flow") ? this.session.getKeycloakSessionFactory().getProviderFactory(FormAction.class, provider) : this.session.getKeycloakSessionFactory().getProviderFactory(Authenticator.class, provider));
        if (f == null) {
            throw new BadRequestException("No authentication provider found for id: " + provider);
        }
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlow.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED);
        execution.setAuthenticatorFlow(false);
        execution.setAuthenticator(provider);
        execution.setPriority(this.getNextPriority(parentFlow));
        this.realm.addAuthenticatorExecution(execution);
    }

    @Path(value="/flows/{flowAlias}/executions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getExecutions(@PathParam(value="flowAlias") String flowAlias) {
        this.auth.requireView();
        AuthenticationFlowModel flow = this.realm.getFlowByAlias(flowAlias);
        if (flow == null) {
            logger.debug("flow not found: " + flowAlias);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        LinkedList<AuthenticationExecutionInfoRepresentation> result = new LinkedList<AuthenticationExecutionInfoRepresentation>();
        int level = 0;
        this.recurseExecutions(flow, result, level);
        return Response.ok(result).build();
    }

    public void recurseExecutions(AuthenticationFlowModel flow, List<AuthenticationExecutionInfoRepresentation> result, int level) {
        int index = 0;
        List executions = this.realm.getAuthenticationExecutions(flow.getId());
        for (AuthenticationExecutionModel execution : executions) {
            AuthenticationExecutionInfoRepresentation rep = new AuthenticationExecutionInfoRepresentation();
            rep.setLevel(level);
            rep.setIndex(index++);
            rep.setRequirementChoices(new LinkedList());
            if (execution.isAuthenticatorFlow()) {
                AuthenticationFlowModel flowRef = this.realm.getAuthenticationFlowById(execution.getFlowId());
                if ("basic-flow".equals(flowRef.getProviderId())) {
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.ALTERNATIVE.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.REQUIRED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.DISABLED.name());
                } else if ("form-flow".equals(flowRef.getProviderId())) {
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.REQUIRED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.DISABLED.name());
                    rep.setProviderId(execution.getAuthenticator());
                    rep.setAuthenticationConfig(execution.getAuthenticatorConfig());
                } else if ("client-flow".equals(flowRef.getProviderId())) {
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.ALTERNATIVE.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.REQUIRED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.DISABLED.name());
                }
                rep.setDisplayName(flowRef.getAlias());
                rep.setConfigurable(Boolean.valueOf(false));
                rep.setId(execution.getId());
                rep.setAuthenticationFlow(Boolean.valueOf(execution.isAuthenticatorFlow()));
                rep.setRequirement(execution.getRequirement().name());
                rep.setFlowId(execution.getFlowId());
                result.add(rep);
                AuthenticationFlowModel subFlow = this.realm.getAuthenticationFlowById(execution.getFlowId());
                this.recurseExecutions(subFlow, result, level + 1);
                continue;
            }
            String providerId = execution.getAuthenticator();
            ConfigurableAuthenticatorFactory factory = CredentialHelper.getConfigurableAuthenticatorFactory(this.session, providerId);
            rep.setDisplayName(factory.getDisplayType());
            rep.setConfigurable(Boolean.valueOf(factory.isConfigurable()));
            for (AuthenticationExecutionModel.Requirement choice : factory.getRequirementChoices()) {
                rep.getRequirementChoices().add(choice.name());
            }
            rep.setId(execution.getId());
            rep.setRequirement(execution.getRequirement().name());
            rep.setProviderId(execution.getAuthenticator());
            rep.setAuthenticationConfig(execution.getAuthenticatorConfig());
            result.add(rep);
        }
    }

    @Path(value="/flows/{flowAlias}/executions")
    @PUT
    @NoCache
    @Consumes(value={"application/json"})
    public void updateExecutions(@PathParam(value="flowAlias") String flowAlias, AuthenticationExecutionInfoRepresentation rep) {
        this.auth.requireManage();
        AuthenticationFlowModel flow = this.realm.getFlowByAlias(flowAlias);
        if (flow == null) {
            logger.debug("flow not found: " + flowAlias);
            throw new NotFoundException("flow not found");
        }
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(rep.getId());
        if (model == null) {
            this.session.getTransaction().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        if (!model.getRequirement().name().equals(rep.getRequirement())) {
            model.setRequirement(AuthenticationExecutionModel.Requirement.valueOf((String)rep.getRequirement()));
            this.realm.updateAuthenticatorExecution(model);
        }
    }

    @Path(value="/executions")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response addExecution(AuthenticationExecutionRepresentation execution) {
        this.auth.requireManage();
        AuthenticationExecutionModel model = RepresentationToModel.toModel((RealmModel)this.realm, (AuthenticationExecutionRepresentation)execution);
        AuthenticationFlowModel parentFlow = this.getParentFlow(model);
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to add execution to a built in flow");
        }
        model.setPriority(this.getNextPriority(parentFlow));
        model = this.realm.addAuthenticatorExecution(model);
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    public AuthenticationFlowModel getParentFlow(AuthenticationExecutionModel model) {
        if (model.getParentFlow() == null) {
            throw new BadRequestException("parent flow not set on new execution");
        }
        AuthenticationFlowModel parentFlow = this.realm.getAuthenticationFlowById(model.getParentFlow());
        if (parentFlow == null) {
            throw new BadRequestException("execution parent flow does not exist");
        }
        return parentFlow;
    }

    @Path(value="/executions/{executionId}/raise-priority")
    @POST
    @NoCache
    public void raisePriority(@PathParam(value="executionId") String execution) {
        this.auth.requireManage();
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransaction().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        AuthenticationFlowModel parentFlow = this.getParentFlow(model);
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to modify execution in a built in flow");
        }
        List<AuthenticationExecutionModel> executions = this.getSortedExecutions(parentFlow);
        AuthenticationExecutionModel previous = null;
        for (AuthenticationExecutionModel exe : executions) {
            if (exe.getId().equals(model.getId())) break;
            previous = exe;
        }
        if (previous == null) {
            return;
        }
        int tmp = previous.getPriority();
        previous.setPriority(model.getPriority());
        this.realm.updateAuthenticatorExecution(previous);
        model.setPriority(tmp);
        this.realm.updateAuthenticatorExecution(model);
    }

    public List<AuthenticationExecutionModel> getSortedExecutions(AuthenticationFlowModel parentFlow) {
        LinkedList<AuthenticationExecutionModel> executions = new LinkedList<AuthenticationExecutionModel>(this.realm.getAuthenticationExecutions(parentFlow.getId()));
        Collections.sort(executions, AuthenticationExecutionModel.ExecutionComparator.SINGLETON);
        return executions;
    }

    @Path(value="/executions/{executionId}/lower-priority")
    @POST
    @NoCache
    public void lowerPriority(@PathParam(value="executionId") String execution) {
        this.auth.requireManage();
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransaction().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        AuthenticationFlowModel parentFlow = this.getParentFlow(model);
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to modify execution in a built in flow");
        }
        List<AuthenticationExecutionModel> executions = this.getSortedExecutions(parentFlow);
        int i = 0;
        for (i = 0; i < executions.size() && !executions.get(i).getId().equals(model.getId()); ++i) {
        }
        if (i + 1 >= executions.size()) {
            return;
        }
        AuthenticationExecutionModel next = executions.get(i + 1);
        int tmp = model.getPriority();
        model.setPriority(next.getPriority());
        this.realm.updateAuthenticatorExecution(model);
        next.setPriority(tmp);
        this.realm.updateAuthenticatorExecution(next);
    }

    @Path(value="/executions/{executionId}")
    @DELETE
    @NoCache
    public void removeExecution(@PathParam(value="executionId") String execution) {
        this.auth.requireManage();
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransaction().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        AuthenticationFlowModel parentFlow = this.getParentFlow(model);
        if (parentFlow.isBuiltIn()) {
            throw new BadRequestException("It is illegal to remove execution from a built in flow");
        }
        if (model.getFlowId() != null) {
            AuthenticationFlowModel nonTopLevelFlow = this.realm.getAuthenticationFlowById(model.getFlowId());
            this.realm.removeAuthenticationFlow(nonTopLevelFlow);
        }
        this.realm.removeAuthenticatorExecution(model);
    }

    @Path(value="/executions/{executionId}/config")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response newExecutionConfig(@PathParam(value="executionId") String execution, AuthenticatorConfigRepresentation json) {
        this.auth.requireManage();
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransaction().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        AuthenticatorConfigModel config = RepresentationToModel.toModel((AuthenticatorConfigRepresentation)json);
        config = this.realm.addAuthenticatorConfig(config);
        model.setAuthenticatorConfig(config.getId());
        this.realm.updateAuthenticatorExecution(model);
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(config.getId()).build(new Object[0])).build();
    }

    @Path(value="/executions/{executionId}/config/{id}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public AuthenticatorConfigRepresentation getAuthenticatorConfig(@PathParam(value="executionId") String execution, @PathParam(value="id") String id) {
        this.auth.requireView();
        AuthenticatorConfigModel config = this.realm.getAuthenticatorConfigById(id);
        if (config == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        return ModelToRepresentation.toRepresentation((AuthenticatorConfigModel)config);
    }

    @Path(value="unregistered-required-actions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<Map<String, String>> getUnregisteredRequiredActions() {
        this.auth.requireView();
        List factories = this.session.getKeycloakSessionFactory().getProviderFactories(RequiredActionProvider.class);
        LinkedList<Map<String, String>> unregisteredList = new LinkedList<Map<String, String>>();
        for (ProviderFactory factory : factories) {
            RequiredActionFactory requiredActionFactory = (RequiredActionFactory)factory;
            boolean found = false;
            for (RequiredActionProviderModel model : this.realm.getRequiredActionProviders()) {
                if (!model.getProviderId().equals(factory.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("name", requiredActionFactory.getDisplayText());
            data.put("providerId", requiredActionFactory.getId());
            unregisteredList.add(data);
        }
        return unregisteredList;
    }

    @Path(value="register-required-action")
    @POST
    @Consumes(value={"application/json"})
    @NoCache
    public void registerRequiredAction(Map<String, String> data) {
        this.auth.requireManage();
        String providerId = data.get("providerId");
        String name = data.get("name");
        RequiredActionProviderModel requiredAction = new RequiredActionProviderModel();
        requiredAction.setAlias(providerId);
        requiredAction.setName(name);
        requiredAction.setProviderId(providerId);
        requiredAction.setDefaultAction(false);
        requiredAction.setEnabled(true);
        this.realm.addRequiredActionProvider(requiredAction);
    }

    @Path(value="required-actions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RequiredActionProviderRepresentation> getRequiredActions() {
        this.auth.requireAny();
        LinkedList<RequiredActionProviderRepresentation> list = new LinkedList<RequiredActionProviderRepresentation>();
        for (RequiredActionProviderModel model : this.realm.getRequiredActionProviders()) {
            RequiredActionProviderRepresentation rep = AuthenticationManagementResource.toRepresentation(model);
            list.add(rep);
        }
        return list;
    }

    public static RequiredActionProviderRepresentation toRepresentation(RequiredActionProviderModel model) {
        RequiredActionProviderRepresentation rep = new RequiredActionProviderRepresentation();
        rep.setAlias(model.getAlias());
        rep.setName(model.getName());
        rep.setDefaultAction(model.isDefaultAction());
        rep.setEnabled(model.isEnabled());
        rep.setConfig(model.getConfig());
        return rep;
    }

    @Path(value="required-actions/{alias}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public RequiredActionProviderRepresentation getRequiredAction(@PathParam(value="alias") String alias) {
        this.auth.requireView();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action");
        }
        return AuthenticationManagementResource.toRepresentation(model);
    }

    @Path(value="required-actions/{alias}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRequiredAction(@PathParam(value="alias") String alias, RequiredActionProviderRepresentation rep) {
        this.auth.requireManage();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action");
        }
        RequiredActionProviderModel update = new RequiredActionProviderModel();
        update.setId(model.getId());
        update.setName(rep.getName());
        update.setAlias(rep.getAlias());
        update.setProviderId(model.getProviderId());
        update.setDefaultAction(rep.isDefaultAction());
        update.setEnabled(rep.isEnabled());
        update.setConfig(rep.getConfig());
        this.realm.updateRequiredActionProvider(update);
    }

    @Path(value="required-actions/{alias}")
    @DELETE
    public void removeRequiredAction(@PathParam(value="alias") String alias) {
        this.auth.requireManage();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action.");
        }
        this.realm.removeRequiredActionProvider(model);
    }

    @Path(value="config-description/{providerId}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public AuthenticatorConfigInfoRepresentation getAuthenticatorConfigDescription(@PathParam(value="providerId") String providerId) {
        this.auth.requireView();
        ConfigurableAuthenticatorFactory factory = CredentialHelper.getConfigurableAuthenticatorFactory(this.session, providerId);
        if (factory == null) {
            throw new NotFoundException("Could not find authenticator provider");
        }
        AuthenticatorConfigInfoRepresentation rep = new AuthenticatorConfigInfoRepresentation();
        rep.setProviderId(providerId);
        rep.setName(factory.getDisplayType());
        rep.setHelpText(factory.getHelpText());
        rep.setProperties(new LinkedList());
        List configProperties = factory.getConfigProperties();
        for (ProviderConfigProperty prop : configProperties) {
            ConfigPropertyRepresentation propRep = this.getConfigPropertyRep(prop);
            rep.getProperties().add(propRep);
        }
        return rep;
    }

    private ConfigPropertyRepresentation getConfigPropertyRep(ProviderConfigProperty prop) {
        ConfigPropertyRepresentation propRep = new ConfigPropertyRepresentation();
        propRep.setName(prop.getName());
        propRep.setLabel(prop.getLabel());
        propRep.setType(prop.getType());
        propRep.setDefaultValue(prop.getDefaultValue());
        propRep.setHelpText(prop.getHelpText());
        return propRep;
    }

    @Path(value="per-client-config-description")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Map<String, List<ConfigPropertyRepresentation>> getPerClientConfigDescription() {
        this.auth.requireAny();
        List factories = this.session.getKeycloakSessionFactory().getProviderFactories(ClientAuthenticator.class);
        HashMap<String, List<ConfigPropertyRepresentation>> toReturn = new HashMap<String, List<ConfigPropertyRepresentation>>();
        for (ProviderFactory clientAuthenticatorFactory : factories) {
            String providerId = clientAuthenticatorFactory.getId();
            ConfigurableAuthenticatorFactory factory = CredentialHelper.getConfigurableAuthenticatorFactory(this.session, providerId);
            ClientAuthenticatorFactory clientAuthFactory = (ClientAuthenticatorFactory)factory;
            List perClientConfigProps = clientAuthFactory.getConfigPropertiesPerClient();
            LinkedList<ConfigPropertyRepresentation> result = new LinkedList<ConfigPropertyRepresentation>();
            for (ProviderConfigProperty prop : perClientConfigProps) {
                ConfigPropertyRepresentation propRep = this.getConfigPropertyRep(prop);
                result.add(propRep);
            }
            toReturn.put(providerId, result);
        }
        return toReturn;
    }

    @Path(value="config")
    @POST
    @NoCache
    public Response createAuthenticatorConfig(AuthenticatorConfigRepresentation rep) {
        this.auth.requireManage();
        AuthenticatorConfigModel config = this.realm.addAuthenticatorConfig(RepresentationToModel.toModel((AuthenticatorConfigRepresentation)rep));
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(config.getId()).build(new Object[0])).build();
    }

    @Path(value="config/{id}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public AuthenticatorConfigRepresentation getAuthenticatorConfig(@PathParam(value="id") String id) {
        this.auth.requireView();
        AuthenticatorConfigModel config = this.realm.getAuthenticatorConfigById(id);
        if (config == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        return ModelToRepresentation.toRepresentation((AuthenticatorConfigModel)config);
    }

    @Path(value="config/{id}")
    @DELETE
    @NoCache
    public void removeAuthenticatorConfig(@PathParam(value="id") String id) {
        this.auth.requireManage();
        AuthenticatorConfigModel config = this.realm.getAuthenticatorConfigById(id);
        if (config == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        LinkedList flows = new LinkedList();
        for (AuthenticationFlowModel flow : this.realm.getAuthenticationFlows()) {
            for (AuthenticationExecutionModel exe : this.realm.getAuthenticationExecutions(flow.getId())) {
                if (!id.equals(exe.getAuthenticatorConfig())) continue;
                exe.setAuthenticatorConfig(null);
                this.realm.updateAuthenticatorExecution(exe);
            }
        }
        this.realm.removeAuthenticatorConfig(config);
    }

    @Path(value="config/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @NoCache
    public void updateAuthenticatorConfig(@PathParam(value="id") String id, AuthenticatorConfigRepresentation rep) {
        this.auth.requireManage();
        AuthenticatorConfigModel exists = this.realm.getAuthenticatorConfigById(id);
        if (exists == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        exists.setAlias(rep.getAlias());
        exists.setConfig(rep.getConfig());
        this.realm.updateAuthenticatorConfig(exists);
    }
}

