/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleResource;

public class RoleContainerResource
extends RoleResource {
    private final RealmModel realm;
    private final RealmAuth auth;
    protected RoleContainerModel roleContainer;
    private AdminEventBuilder adminEvent;
    private UriInfo uriInfo;

    public RoleContainerResource(UriInfo uriInfo, RealmModel realm, RealmAuth auth, RoleContainerModel roleContainer, AdminEventBuilder adminEvent) {
        super(realm);
        this.uriInfo = uriInfo;
        this.realm = realm;
        this.auth = auth;
        this.roleContainer = roleContainer;
        this.adminEvent = adminEvent;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<RoleRepresentation> getRoles() {
        this.auth.requireAny();
        if (this.roleContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        Set roleModels = this.roleContainer.getRoles();
        ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roleModels) {
            roles.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return roles;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createRole(RoleRepresentation rep) {
        this.auth.requireManage();
        if (this.roleContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        if (rep.getName() == null) {
            throw new BadRequestException();
        }
        try {
            RoleModel role = this.roleContainer.addRole(rep.getName());
            role.setDescription(rep.getDescription());
            boolean scopeParamRequired = rep.isScopeParamRequired() == null ? false : rep.isScopeParamRequired();
            role.setScopeParamRequired(scopeParamRequired);
            this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo, role.getId()).representation(rep).success();
            return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(role.getName()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Role with name " + rep.getName() + " already exists");
        }
    }

    @Path(value="{role-name}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RoleRepresentation getRole(@PathParam(value="role-name") String roleName) {
        this.auth.requireView();
        if (this.roleContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        RoleModel roleModel = this.roleContainer.getRole(roleName);
        if (roleModel == null) {
            throw new NotFoundException("Could not find role");
        }
        return this.getRole(roleModel);
    }

    @Path(value="{role-name}")
    @DELETE
    @NoCache
    public void deleteRole(@PathParam(value="role-name") String roleName) {
        this.auth.requireManage();
        if (this.roleContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        RoleRepresentation rep = this.getRole(roleName);
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        this.deleteRole(role);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @Path(value="{role-name}")
    @PUT
    @Consumes(value={"application/json"})
    public Response updateRole(@PathParam(value="role-name") String roleName, RoleRepresentation rep) {
        this.auth.requireManage();
        if (this.roleContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        try {
            this.updateRole(rep, role);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Role with name " + rep.getName() + " already exists");
        }
    }

    @Path(value="{role-name}/composites")
    @POST
    @Consumes(value={"application/json"})
    public void addComposites(@PathParam(value="role-name") String roleName, List<RoleRepresentation> roles) {
        this.auth.requireManage();
        if (this.roleContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        this.addComposites(this.adminEvent, this.uriInfo, roles, role);
    }

    @Path(value="{role-name}/composites")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRoleComposites(@PathParam(value="role-name") String roleName) {
        this.auth.requireView();
        if (this.roleContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        return this.getRoleComposites(role);
    }

    @Path(value="{role-name}/composites/realm")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRealmRoleComposites(@PathParam(value="role-name") String roleName) {
        this.auth.requireView();
        if (this.roleContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        return this.getRealmRoleComposites(role);
    }

    @Path(value="{role-name}/composites/clients/{client}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getClientRoleComposites(@Context UriInfo uriInfo, @PathParam(value="role-name") String roleName, @PathParam(value="client") String client) {
        this.auth.requireView();
        if (this.roleContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        ClientModel clientModel = this.realm.getClientById(client);
        if (client == null) {
            throw new NotFoundException("Could not find client");
        }
        return this.getClientRoleComposites(clientModel, role);
    }

    @Path(value="{role-name}/composites")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteComposites(@PathParam(value="role-name") String roleName, List<RoleRepresentation> roles) {
        this.auth.requireManage();
        if (this.roleContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        RoleModel role = this.roleContainer.getRole(roleName);
        if (role == null) {
            throw new NotFoundException("Could not find role");
        }
        this.deleteComposites(roles, role);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }
}

