/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra.processors;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class CachedConnectionManagerSetupProcessor
implements DeploymentUnitProcessor {
    private static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"jca", "cachedConnectionManagerSetupProcessor"});

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ServiceName serviceName = deploymentUnit.getServiceName().append(SERVICE_NAME);
        CachedConnectionManagerSetupAction action = new CachedConnectionManagerSetupAction(serviceName);
        phaseContext.getServiceTarget().addService(serviceName, (Service)action).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, (Injector)action.cachedConnectionManager).install();
        deploymentUnit.addToAttachmentList(Attachments.WEB_SETUP_ACTIONS, (Object)action);
        deploymentUnit.addToAttachmentList(Attachments.OTHER_EE_SETUP_ACTIONS, (Object)action);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static class CachedConnectionManagerSetupAction
    implements SetupAction,
    Service<Void> {
        private final InjectedValue<CachedConnectionManager> cachedConnectionManager = new InjectedValue();
        private final ServiceName serviceName;
        private static final Set<?> unsharable = new HashSet();

        private CachedConnectionManagerSetupAction(ServiceName serviceName) {
            this.serviceName = serviceName;
        }

        public void setup(Map<String, Object> properties) {
            try {
                CachedConnectionManager connectionManager = (CachedConnectionManager)this.cachedConnectionManager.getOptionalValue();
                if (connectionManager != null) {
                    connectionManager.pushMetaAwareObject((Object)this, unsharable);
                }
            }
            catch (ResourceException e) {
                throw new RuntimeException(e);
            }
        }

        public void teardown(Map<String, Object> properties) {
            try {
                CachedConnectionManager connectionManager = (CachedConnectionManager)this.cachedConnectionManager.getOptionalValue();
                if (connectionManager != null) {
                    connectionManager.popMetaAwareObject(unsharable);
                }
            }
            catch (ResourceException e) {
                throw new RuntimeException(e);
            }
        }

        public int priority() {
            return 0;
        }

        public Set<ServiceName> dependencies() {
            return Collections.singleton(this.serviceName);
        }

        public void start(StartContext context) throws StartException {
        }

        public void stop(StopContext context) {
        }

        public Void getValue() throws IllegalStateException, IllegalArgumentException {
            return null;
        }
    }
}

