/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.distributable;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.UUID;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.CacheFactoryBuilderService;
import org.jboss.as.ejb3.cache.Contextual;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryBuilder;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryService;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilderConfiguration;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilderFactory;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilderFactoryProvider;
import org.wildfly.clustering.service.Builder;

public class DistributableCacheFactoryBuilderService<K, V extends Identifiable<K> & Contextual<Batch>>
extends AbstractService<DistributableCacheFactoryBuilder<K, V>>
implements DistributableCacheFactoryBuilder<K, V> {
    private final String name;
    private final BeanManagerFactoryBuilderFactory<UUID, K, Batch> builder;
    private final BeanManagerFactoryBuilderConfiguration config;

    public static ServiceName getServiceName(String name) {
        return CacheFactoryBuilderService.BASE_CACHE_FACTORY_SERVICE_NAME.append(new String[]{"distributable", name});
    }

    public DistributableCacheFactoryBuilderService(String name, BeanManagerFactoryBuilderConfiguration config) {
        this(name, DistributableCacheFactoryBuilderService.load(), config);
    }

    private static BeanManagerFactoryBuilderFactoryProvider<Batch> load() {
        Iterator<BeanManagerFactoryBuilderFactoryProvider> iterator = ServiceLoader.load(BeanManagerFactoryBuilderFactoryProvider.class, BeanManagerFactoryBuilderFactoryProvider.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            BeanManagerFactoryBuilderFactoryProvider provider = iterator.next();
            return provider;
        }
        return null;
    }

    public DistributableCacheFactoryBuilderService(String name, BeanManagerFactoryBuilderFactoryProvider<Batch> provider, BeanManagerFactoryBuilderConfiguration config) {
        this.name = name;
        this.config = config;
        this.builder = provider.getBeanManagerFactoryBuilder(name, config);
    }

    public ServiceBuilder<DistributableCacheFactoryBuilder<K, V>> build(ServiceTarget target) {
        return target.addService(DistributableCacheFactoryBuilderService.getServiceName(this.name), (Service)this);
    }

    public DistributableCacheFactoryBuilder<K, V> getValue() {
        return this;
    }

    @Override
    public BeanManagerFactoryBuilderConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void installDeploymentUnitDependencies(ServiceTarget target, ServiceName deploymentUnitServiceName) {
        for (Builder builder : this.builder.getDeploymentBuilders(deploymentUnitServiceName)) {
            builder.build(target).install();
        }
    }

    @Override
    public ServiceBuilder<? extends CacheFactory<K, V>> build(ServiceTarget target, ServiceName serviceName, BeanContext context, StatefulTimeoutInfo statefulTimeout) {
        Builder builder = this.builder.getBeanManagerFactoryBuilder(context);
        return new DistributableCacheFactoryService(serviceName, builder).build(target);
    }

    @Override
    public boolean supportsPassivation() {
        return true;
    }
}

