/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.io.Receiver;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;

public class BlockingReceiverImpl
implements Receiver {
    private static final Receiver.ErrorCallback END_EXCHANGE = new Receiver.ErrorCallback(){

        @Override
        public void error(HttpServerExchange exchange, IOException e) {
            if (!exchange.isResponseStarted()) {
                exchange.setStatusCode(500);
            }
            exchange.setPersistent(false);
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            exchange.endExchange();
        }
    };
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final HttpServerExchange exchange;
    private final InputStream inputStream;
    private int maxBufferSize = -1;
    private boolean paused = false;
    private boolean done = false;

    public BlockingReceiverImpl(HttpServerExchange exchange, InputStream inputStream) {
        this.exchange = exchange;
        this.inputStream = inputStream;
    }

    @Override
    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public void receiveFullString(Receiver.FullStringCallback callback, Receiver.ErrorCallback errorCallback) {
        this.receiveFullString(callback, errorCallback, StandardCharsets.ISO_8859_1);
    }

    @Override
    public void receiveFullString(Receiver.FullStringCallback callback) {
        this.receiveFullString(callback, END_EXCHANGE, StandardCharsets.ISO_8859_1);
    }

    @Override
    public void receivePartialString(Receiver.PartialStringCallback callback, Receiver.ErrorCallback errorCallback) {
        this.receivePartialString(callback, errorCallback, StandardCharsets.ISO_8859_1);
    }

    @Override
    public void receivePartialString(Receiver.PartialStringCallback callback) {
        this.receivePartialString(callback, END_EXCHANGE, StandardCharsets.ISO_8859_1);
    }

    @Override
    public void receiveFullString(Receiver.FullStringCallback callback, Receiver.ErrorCallback errorCallback, Charset charset) {
        ByteArrayOutputStream sb;
        long contentLength;
        Receiver.ErrorCallback error;
        if (this.done) {
            throw UndertowMessages.MESSAGES.requestBodyAlreadyRead();
        }
        Receiver.ErrorCallback errorCallback2 = error = errorCallback == null ? END_EXCHANGE : errorCallback;
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.exchange.isRequestComplete()) {
            callback.handle(this.exchange, "");
            return;
        }
        String contentLengthString = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
            if (contentLength > Integer.MAX_VALUE) {
                error.error(this.exchange, new Receiver.RequestToLargeException());
                return;
            }
            sb = new ByteArrayOutputStream((int)contentLength);
        } else {
            contentLength = -1L;
            sb = new ByteArrayOutputStream();
        }
        if (this.maxBufferSize > 0 && contentLength > (long)this.maxBufferSize) {
            error.error(this.exchange, new Receiver.RequestToLargeException());
            return;
        }
        byte[] buffer = new byte[1024];
        try {
            int s;
            while ((s = this.inputStream.read(buffer)) > 0) {
                sb.write(buffer, 0, s);
            }
            callback.handle(this.exchange, sb.toString(charset.name()));
        }
        catch (IOException e) {
            error.error(this.exchange, e);
        }
    }

    @Override
    public void receiveFullString(Receiver.FullStringCallback callback, Charset charset) {
        this.receiveFullString(callback, END_EXCHANGE, charset);
    }

    @Override
    public void receivePartialString(Receiver.PartialStringCallback callback, Receiver.ErrorCallback errorCallback, Charset charset) {
        long contentLength;
        Receiver.ErrorCallback error;
        if (this.done) {
            throw UndertowMessages.MESSAGES.requestBodyAlreadyRead();
        }
        Receiver.ErrorCallback errorCallback2 = error = errorCallback == null ? END_EXCHANGE : errorCallback;
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.exchange.isRequestComplete()) {
            callback.handle(this.exchange, "", true);
            return;
        }
        String contentLengthString = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
            if (contentLength > Integer.MAX_VALUE) {
                error.error(this.exchange, new Receiver.RequestToLargeException());
                return;
            }
        } else {
            contentLength = -1L;
        }
        if (this.maxBufferSize > 0 && contentLength > (long)this.maxBufferSize) {
            error.error(this.exchange, new Receiver.RequestToLargeException());
            return;
        }
        CharsetDecoder decoder = charset.newDecoder();
        byte[] buffer = new byte[1024];
        try {
            int s;
            while ((s = this.inputStream.read(buffer)) > 0) {
                CharBuffer res = decoder.decode(ByteBuffer.wrap(buffer, 0, s));
                callback.handle(this.exchange, res.toString(), false);
            }
            callback.handle(this.exchange, "", true);
        }
        catch (IOException e) {
            error.error(this.exchange, e);
        }
    }

    @Override
    public void receivePartialString(Receiver.PartialStringCallback callback, Charset charset) {
        this.receivePartialString(callback, END_EXCHANGE, charset);
    }

    @Override
    public void receiveFullBytes(Receiver.FullBytesCallback callback, Receiver.ErrorCallback errorCallback) {
        ByteArrayOutputStream sb;
        long contentLength;
        Receiver.ErrorCallback error;
        if (this.done) {
            throw UndertowMessages.MESSAGES.requestBodyAlreadyRead();
        }
        Receiver.ErrorCallback errorCallback2 = error = errorCallback == null ? END_EXCHANGE : errorCallback;
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.exchange.isRequestComplete()) {
            callback.handle(this.exchange, EMPTY_BYTE_ARRAY);
            return;
        }
        String contentLengthString = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
            if (contentLength > Integer.MAX_VALUE) {
                error.error(this.exchange, new Receiver.RequestToLargeException());
                return;
            }
            sb = new ByteArrayOutputStream((int)contentLength);
        } else {
            contentLength = -1L;
            sb = new ByteArrayOutputStream();
        }
        if (this.maxBufferSize > 0 && contentLength > (long)this.maxBufferSize) {
            error.error(this.exchange, new Receiver.RequestToLargeException());
            return;
        }
        byte[] buffer = new byte[1024];
        try {
            int s;
            while ((s = this.inputStream.read(buffer)) > 0) {
                sb.write(buffer, 0, s);
            }
            callback.handle(this.exchange, sb.toByteArray());
        }
        catch (IOException e) {
            error.error(this.exchange, e);
        }
    }

    @Override
    public void receiveFullBytes(Receiver.FullBytesCallback callback) {
        this.receiveFullBytes(callback, END_EXCHANGE);
    }

    @Override
    public void receivePartialBytes(Receiver.PartialBytesCallback callback, Receiver.ErrorCallback errorCallback) {
        long contentLength;
        Receiver.ErrorCallback error;
        if (this.done) {
            throw UndertowMessages.MESSAGES.requestBodyAlreadyRead();
        }
        Receiver.ErrorCallback errorCallback2 = error = errorCallback == null ? END_EXCHANGE : errorCallback;
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.exchange.isRequestComplete()) {
            callback.handle(this.exchange, EMPTY_BYTE_ARRAY, true);
            return;
        }
        String contentLengthString = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
            if (contentLength > Integer.MAX_VALUE) {
                error.error(this.exchange, new Receiver.RequestToLargeException());
                return;
            }
        } else {
            contentLength = -1L;
        }
        if (this.maxBufferSize > 0 && contentLength > (long)this.maxBufferSize) {
            error.error(this.exchange, new Receiver.RequestToLargeException());
            return;
        }
        byte[] buffer = new byte[1024];
        try {
            int s;
            while ((s = this.inputStream.read(buffer)) > 0) {
                byte[] newData = new byte[s];
                System.arraycopy(buffer, 0, newData, 0, s);
                callback.handle(this.exchange, newData, false);
            }
            callback.handle(this.exchange, EMPTY_BYTE_ARRAY, true);
        }
        catch (IOException e) {
            error.error(this.exchange, e);
        }
    }

    @Override
    public void receivePartialBytes(Receiver.PartialBytesCallback callback) {
        this.receivePartialBytes(callback, END_EXCHANGE);
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
    }
}

