/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServerFactory;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.auth.sasl.SaslClientCallbackHandler;
import org.jgroups.auth.sasl.SaslClientContext;
import org.jgroups.auth.sasl.SaslContext;
import org.jgroups.auth.sasl.SaslServerContext;
import org.jgroups.auth.sasl.SaslUtils;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.SaslHeader;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

@MBean(description="Provides SASL authentication")
public class SASL
extends Protocol {
    public static final short GMS_ID = ClassConfigurator.getProtocolId(GMS.class);
    public static final short SASL_ID = ClassConfigurator.getProtocolId(SASL.class);
    public static final String SASL_PROTOCOL_NAME = "jgroups";
    @Property(name="login_module_name", description="The name of the JAAS login module to use to obtain a subject for creating the SASL client and server (optional). Only required by some SASL mechs (e.g. GSSAPI)")
    protected String login_module_name;
    @Property(name="client_name", description="The name to use when a node is acting as a client (i.e. it is not the coordinator. Will also be used to obtain the subject if using a JAAS login module")
    protected String client_name;
    @Property(name="client_password", description="The password to use when a node is acting as a client (i.e. it is not the coordinator. Will also be used to obtain the subject if using a JAAS login module", exposeAsManagedAttribute=false)
    protected String client_password;
    @Property(name="mech", description="The name of the mech to require for authentication. Can be any mech supported by your local SASL provider. The JDK comes standard with CRAM-MD5, DIGEST-MD5, GSSAPI, NTLM")
    protected String mech;
    @Property(name="sasl_props", description="Properties specific to the chosen mech", converter=PropertyConverters.StringProperties.class)
    protected Map<String, String> sasl_props = new HashMap<String, String>();
    @Property(name="server_name", description="The fully qualified server name")
    protected String server_name;
    @Property(name="timeout", description="How long to wait (in ms) for a response to a challenge")
    protected long timeout = 5000L;
    @Property(name="client_callback_handler", description="The CallbackHandler to use when a node acts as a client (i.e. it is not the coordinator")
    protected CallbackHandler client_callback_handler;
    @Property(name="server_callback_handler", description="The CallbackHandler to use when a node acts as a server (i.e. it is the coordinator")
    protected CallbackHandler server_callback_handler;
    protected Subject client_subject;
    protected Subject server_subject;
    protected Address local_addr;
    protected final Map<Address, SaslContext> sasl_context = new HashMap<Address, SaslContext>();
    private SaslServerFactory saslServerFactory;
    private SaslClientFactory saslClientFactory;

    public SASL() {
        this.name = this.getClass().getSimpleName();
    }

    @Property(name="client_callback_handler_class")
    public void setClientCallbackHandlerClass(String handlerClass) throws Exception {
        this.client_callback_handler = Class.forName(handlerClass).asSubclass(CallbackHandler.class).newInstance();
    }

    public String getClientCallbackHandlerClass() {
        return this.client_callback_handler != null ? this.client_callback_handler.getClass().getName() : null;
    }

    public CallbackHandler getClientCallbackHandler() {
        return this.client_callback_handler;
    }

    public void setClientCallbackHandler(CallbackHandler client_callback_handler) {
        this.client_callback_handler = client_callback_handler;
    }

    @Property(name="server_callback_handler_class")
    public void setServerCallbackHandlerClass(String handlerClass) throws Exception {
        this.server_callback_handler = Class.forName(handlerClass).asSubclass(CallbackHandler.class).newInstance();
    }

    public String getServerCallbackHandlerClass() {
        return this.server_callback_handler != null ? this.server_callback_handler.getClass().getName() : null;
    }

    public CallbackHandler getServerCallbackHandler() {
        return this.server_callback_handler;
    }

    public void setServerCallbackHandler(CallbackHandler server_callback_handler) {
        this.server_callback_handler = server_callback_handler;
    }

    public void setLoginModuleName(String login_module_name) {
        this.login_module_name = login_module_name;
    }

    public String getLoginModulename() {
        return this.login_module_name;
    }

    public void setMech(String mech) {
        this.mech = mech;
    }

    public String getMech() {
        return this.mech;
    }

    public void setSaslProps(Map<String, String> sasl_props) {
        this.sasl_props = sasl_props;
    }

    public Map<String, String> getSaslProps() {
        return this.sasl_props;
    }

    public void setClientSubject(Subject client_subject) {
        this.client_subject = client_subject;
    }

    public Subject getClientSubject() {
        return this.client_subject;
    }

    public void setServerSubject(Subject server_subject) {
        this.server_subject = server_subject;
    }

    public Subject getServerSubject() {
        return this.server_subject;
    }

    public void setServerName(String server_name) {
        this.server_name = server_name;
    }

    public String getServerName(String server_name) {
        return server_name;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Address getAddress() {
        return this.local_addr;
    }

    @Override
    public void init() throws Exception {
        LoginContext lc;
        char[] client_password_chars;
        super.init();
        this.saslServerFactory = SaslUtils.getSaslServerFactory(this.mech, this.sasl_props);
        this.saslClientFactory = SaslUtils.getSaslClientFactory(this.mech, this.sasl_props);
        char[] cArray = client_password_chars = this.client_password == null ? new char[]{} : this.client_password.toCharArray();
        if (this.client_callback_handler == null && this.client_password != null) {
            this.client_callback_handler = new SaslClientCallbackHandler(this.client_name, client_password_chars);
        }
        if (this.server_subject == null && this.login_module_name != null) {
            lc = new LoginContext(this.login_module_name);
            lc.login();
            this.server_subject = lc.getSubject();
        }
        if (this.client_subject == null && this.login_module_name != null) {
            lc = new LoginContext(this.login_module_name, new SaslClientCallbackHandler(this.client_name, client_password_chars));
            lc.login();
            this.client_subject = lc.getSubject();
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.cleanup();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.cleanup();
    }

    private void cleanup() {
        for (SaslContext context : this.sasl_context.values()) {
            context.dispose();
        }
        this.sasl_context.clear();
    }

    @Override
    public Object up(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            SaslHeader saslHeader = (SaslHeader)msg.getHeader(SASL_ID);
            GMS.GmsHeader gmsHeader = (GMS.GmsHeader)msg.getHeader(GMS_ID);
            if (SASL.needsAuthentication(gmsHeader)) {
                if (saslHeader == null) {
                    throw new IllegalStateException("Found GMS join or merge request but no SASL header");
                }
                if (!this.serverChallenge(gmsHeader, saslHeader, msg)) {
                    return null;
                }
            } else if (saslHeader != null) {
                Address remoteAddress = msg.getSrc();
                SaslContext saslContext = this.sasl_context.get(remoteAddress);
                if (saslContext == null) {
                    throw new IllegalStateException(String.format("Cannot find server context to challenge SASL request from %s", remoteAddress.toString()));
                }
                switch (saslHeader.getType()) {
                    case CHALLENGE: {
                        try {
                            Message response;
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("%s: received CHALLENGE from %s", this.getAddress(), remoteAddress);
                            }
                            if ((response = saslContext.nextMessage(remoteAddress, saslHeader)) != null) {
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace("%s: sending RESPONSE to %s", this.getAddress(), remoteAddress);
                                }
                                this.down_prot.down(new Event(1, response));
                                break;
                            }
                            if (!saslContext.isSuccessful()) {
                                throw new SaslException("computed response is null but challenge-response cycle not complete!");
                            }
                            if (!this.log.isTraceEnabled()) break;
                            this.log.trace("%s: authentication complete from %s", this.getAddress(), remoteAddress);
                        }
                        catch (SaslException e) {
                            this.disposeContext(remoteAddress);
                            if (!this.log.isWarnEnabled()) break;
                            this.log.warn("failed to validate CHALLENGE from " + remoteAddress + ", token", e);
                        }
                        break;
                    }
                    case RESPONSE: {
                        try {
                            Message challenge;
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("%s: received RESPONSE from %s", this.getAddress(), remoteAddress);
                            }
                            if ((challenge = saslContext.nextMessage(remoteAddress, saslHeader)) != null) {
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace("%s: sending CHALLENGE to %s", this.getAddress(), remoteAddress);
                                }
                                this.down_prot.down(new Event(1, challenge));
                                break;
                            }
                            if (!saslContext.isSuccessful()) {
                                throw new SaslException("computed challenge is null but challenge-response cycle not complete!");
                            }
                            if (!this.log.isTraceEnabled()) break;
                            this.log.trace("%s: authentication complete from %s", this.getAddress(), remoteAddress);
                            break;
                        }
                        catch (SaslException e) {
                            this.disposeContext(remoteAddress);
                            if (!this.log.isWarnEnabled()) break;
                            this.log.warn("failed to validate RESPONSE from " + remoteAddress + ", token", e);
                        }
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    private void disposeContext(Address address) {
        SaslContext context = this.sasl_context.remove(address);
        if (context != null) {
            context.dispose();
        }
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            GMS.GmsHeader gmsHeader = (GMS.GmsHeader)msg.getHeader(GMS_ID);
            if (!SASL.needsAuthentication(gmsHeader)) continue;
            SaslHeader saslHeader = (SaslHeader)msg.getHeader(this.id);
            if (saslHeader == null) {
                this.log.warn("Found GMS join or merge request but no SASL header");
                this.sendRejectionMessage(gmsHeader.getType(), batch.sender(), "join or merge without an SASL header");
                batch.remove(msg);
                continue;
            }
            if (this.serverChallenge(gmsHeader, saslHeader, msg)) continue;
            batch.remove(msg);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
                if (!SASL.needsAuthentication(hdr)) break;
                SaslClientContext ctx = null;
                Address remoteAddress = msg.getDest();
                try {
                    ctx = new SaslClientContext(this.saslClientFactory, this.mech, this.server_name != null ? this.server_name : remoteAddress.toString(), this.client_callback_handler, this.sasl_props, this.client_subject);
                    this.sasl_context.put(remoteAddress, ctx);
                    ctx.addHeader(msg, null);
                    break;
                }
                catch (Exception e) {
                    if (ctx != null) {
                        this.disposeContext(remoteAddress);
                    }
                    throw new SecurityException(e);
                }
            }
        }
        return this.down_prot.down(evt);
    }

    protected static boolean needsAuthentication(GMS.GmsHeader hdr) {
        return hdr != null && (hdr.getType() == 1 || hdr.getType() == 11 || hdr.getType() == 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean serverChallenge(GMS.GmsHeader gmsHeader, SaslHeader saslHeader, Message msg) {
        switch (gmsHeader.getType()) {
            case 1: 
            case 6: 
            case 11: {
                remoteAddress = msg.getSrc();
                ctx = null;
                ctx = new SaslServerContext(this.saslServerFactory, this.mech, this.server_name != null ? this.server_name : this.local_addr.toString(), this.server_callback_handler, this.sasl_props, this.server_subject);
                this.sasl_context.put(remoteAddress, ctx);
                this.getDownProtocol().down(new Event(1, ctx.nextMessage(remoteAddress, saslHeader)));
                ctx.awaitCompletion(this.timeout);
                if (!ctx.isSuccessful()) ** GOTO lbl19
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Authentication successful for %s", new Object[]{ctx.getAuthorizationID()});
                }
                var6_6 = true;
                if (ctx != null && !ctx.needsWrapping()) {
                    this.disposeContext(remoteAddress);
                }
                return var6_6;
lbl19:
                // 1 sources

                try {
                    this.log.warn("failed to validate SaslHeader from %s, header: %s", new Object[]{msg.getSrc(), saslHeader});
                    this.sendRejectionMessage(gmsHeader.getType(), msg.getSrc(), "authentication failed");
                    var6_7 = false;
                    if (ctx != null && !ctx.needsWrapping()) {
                        this.disposeContext(remoteAddress);
                    }
                    return var6_7;
                }
                catch (SaslException e) {
                    this.log.warn("failed to validate SaslHeader from %s, header: %s", new Object[]{msg.getSrc(), saslHeader});
                    this.sendRejectionMessage(gmsHeader.getType(), msg.getSrc(), "authentication failed");
                    if (ctx == null || ctx.needsWrapping()) break;
                    this.disposeContext(remoteAddress);
                    break;
                }
                catch (InterruptedException e) {
                    var7_10 = false;
                    return var7_10;
                    {
                        catch (Throwable var8_11) {
                            throw var8_11;
                        }
                    }
                    finally {
                        if (ctx != null && !ctx.needsWrapping()) {
                            this.disposeContext(remoteAddress);
                        }
                    }
                }
            }
        }
        return true;
    }

    protected void sendRejectionMessage(byte type, Address dest, String error_msg) {
        switch (type) {
            case 1: 
            case 11: {
                this.sendJoinRejectionMessage(dest, error_msg);
                break;
            }
            case 6: {
                this.sendMergeRejectionMessage(dest);
                break;
            }
            default: {
                this.log.error("type " + type + " unknown");
            }
        }
    }

    protected void sendJoinRejectionMessage(Address dest, String error_msg) {
        if (dest == null) {
            return;
        }
        JoinRsp joinRes = new JoinRsp(error_msg);
        Message msg = new Message(dest).putHeader(GMS_ID, new GMS.GmsHeader(2)).setBuffer(GMS.marshal(joinRes));
        this.down_prot.down(new Event(1, msg));
    }

    protected void sendMergeRejectionMessage(Address dest) {
        Message msg = new Message(dest).setFlag(Message.Flag.OOB);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.setMergeRejected(true);
        msg.putHeader(GMS_ID, hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug("merge response=" + hdr);
        }
        this.down_prot.down(new Event(1, msg));
    }
}

