/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import javax.batch.api.Batchlet;
import javax.batch.api.partition.PartitionCollector;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.runtime.BatchStatus;
import org.jberet._private.BatchLogger;
import org.jberet.creation.JobScopedContextImpl;
import org.jberet.job.model.RefArtifact;
import org.jberet.runtime.JobStopNotificationListener;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.AbstractRunner;
import org.jberet.runtime.runner.CompositeExecutionRunner;
import org.jberet.runtime.runner.ScriptBatchlet;
import org.jberet.runtime.runner.StepExecutionRunner;
import org.jberet.spi.JobTask;

public final class BatchletRunner
extends AbstractRunner<StepContextImpl>
implements JobTask,
JobStopNotificationListener {
    private final RefArtifact batchlet;
    private final StepExecutionRunner stepRunner;
    private PartitionCollector collector;
    private Batchlet batchletObj;

    public BatchletRunner(StepContextImpl stepContext, CompositeExecutionRunner enclosingRunner, StepExecutionRunner stepRunner, RefArtifact batchlet) {
        super(stepContext, enclosingRunner);
        this.stepRunner = stepRunner;
        this.batchlet = batchlet;
    }

    @Override
    public void stopRequested() {
        if (((StepContextImpl)this.batchContext).getBatchStatus() == BatchStatus.STARTED) {
            ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPING);
            if (this.batchletObj != null) {
                try {
                    this.batchletObj.stop();
                }
                catch (Exception e) {
                    BatchLogger.LOGGER.failToStopJob(e, this.jobContext.getJobName(), ((StepContextImpl)this.batchContext).getStepName(), this.batchletObj);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block27: {
            block26: {
                RefArtifact collectorConfig;
                if (this.stepRunner.collectorDataQueue != null && (collectorConfig = ((StepContextImpl)this.batchContext).getStep().getPartition().getCollector()) != null) {
                    this.collector = (PartitionCollector)this.jobContext.createArtifact(collectorConfig.getRef(), null, collectorConfig.getProperties(), (StepContextImpl)this.batchContext);
                }
                this.batchletObj = (Batchlet)this.createArtifact(this.batchlet, (StepContextImpl)this.batchContext, ScriptBatchlet.class);
                String exitStatus = null;
                if (this.jobContext.getJobExecution().isStopRequested()) {
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPING);
                } else {
                    this.jobContext.getJobExecution().registerJobStopNotifier(this);
                    exitStatus = this.batchletObj.process();
                    this.jobContext.getJobExecution().unregisterJobStopNotifier(this);
                }
                switch (((StepContextImpl)this.batchContext).getBatchStatus()) {
                    case STARTED: {
                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
                        break;
                    }
                    case STOPPING: {
                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPED);
                    }
                }
                ((StepContextImpl)this.batchContext).setExitStatus(exitStatus);
                if (this.collector == null) break block26;
                this.stepRunner.collectorDataQueue.put(this.collector.collectPartitionData());
            }
            try {
                if (this.stepRunner.collectorDataQueue != null) {
                    this.stepRunner.collectorDataQueue.put(((StepContextImpl)this.batchContext).getStepExecution());
                    JobScopedContextImpl.ScopedInstance.destroy(((StepContextImpl)this.batchContext).getPartitionScopedBeans());
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.stepRunner.completedPartitionThreads != null) {
                this.stepRunner.completedPartitionThreads.offer(Boolean.TRUE);
            }
            this.jobContext.destroyArtifact(this.batchletObj, this.collector);
            break block27;
            catch (Throwable e) {
                try {
                    try {
                        if (this.collector != null) {
                            this.stepRunner.collectorDataQueue.put(this.collector.collectPartitionData());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ((StepContextImpl)this.batchContext).setException((Exception)(e instanceof Exception ? (Exception)e : new BatchRuntimeException(e)));
                    BatchLogger.LOGGER.failToRunBatchlet(e, this.batchlet);
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                }
                catch (Throwable throwable) {
                    try {
                        if (this.stepRunner.collectorDataQueue != null) {
                            this.stepRunner.collectorDataQueue.put(((StepContextImpl)this.batchContext).getStepExecution());
                            JobScopedContextImpl.ScopedInstance.destroy(((StepContextImpl)this.batchContext).getPartitionScopedBeans());
                        }
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    if (this.stepRunner.completedPartitionThreads != null) {
                        this.stepRunner.completedPartitionThreads.offer(Boolean.TRUE);
                    }
                    this.jobContext.destroyArtifact(this.batchletObj, this.collector);
                    throw throwable;
                }
                try {
                    if (this.stepRunner.collectorDataQueue != null) {
                        this.stepRunner.collectorDataQueue.put(((StepContextImpl)this.batchContext).getStepExecution());
                        JobScopedContextImpl.ScopedInstance.destroy(((StepContextImpl)this.batchContext).getPartitionScopedBeans());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.stepRunner.completedPartitionThreads != null) {
                    this.stepRunner.completedPartitionThreads.offer(Boolean.TRUE);
                }
                this.jobContext.destroyArtifact(this.batchletObj, this.collector);
            }
        }
    }
}

