/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.generator;

import org.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import org.cryptacular.generator.IdGenerator;
import org.cryptacular.util.NonceUtil;

public class RandomIdGenerator
implements IdGenerator {
    public static final String DEFAULT_CHARSET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private final int length;
    private final String charset;
    private final SP80090DRBG rbg;

    public RandomIdGenerator(int length) {
        this(length, DEFAULT_CHARSET);
    }

    public RandomIdGenerator(int length, String charset) {
        if (length < 1) {
            throw new IllegalArgumentException("Length must be positive");
        }
        this.length = length;
        if (charset == null || charset.length() < 2 || charset.length() > 128) {
            throw new IllegalArgumentException("Charset length must be in the range 2 - 128");
        }
        this.charset = charset;
        this.rbg = NonceUtil.newRBG(8);
    }

    @Override
    public String generate() {
        StringBuilder id = new StringBuilder(this.length);
        byte[] bits = new byte[1];
        for (int i = 0; i < this.length; ++i) {
            this.rbg.generate(bits, null, false);
            int index = 0x7F & bits[0];
            id.append(this.charset.charAt(index % this.charset.length()));
        }
        return id.toString();
    }
}

