/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoGroupEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class GroupAdapter
extends AbstractMongoAdapter<MongoGroupEntity>
implements GroupModel {
    private final MongoGroupEntity group;
    private RealmModel realm;
    private KeycloakSession session;

    public GroupAdapter(KeycloakSession session, RealmModel realm, MongoGroupEntity group, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.group = group;
        this.realm = realm;
        this.session = session;
    }

    public String getId() {
        return this.group.getId();
    }

    public String getName() {
        return this.group.getName();
    }

    public void setName(String name) {
        this.group.setName(name);
        this.updateGroup();
    }

    protected void updateGroup() {
        super.updateMongoEntity();
    }

    @Override
    public MongoGroupEntity getMongoEntity() {
        return this.group;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof GroupModel)) {
            return false;
        }
        GroupModel that = (GroupModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    public void setSingleAttribute(String name, String value) {
        if (this.group.getAttributes() == null) {
            this.group.setAttributes(new HashMap());
        }
        ArrayList<String> attrValues = new ArrayList<String>();
        attrValues.add(value);
        this.group.getAttributes().put(name, attrValues);
        this.updateGroup();
    }

    public void setAttribute(String name, List<String> values) {
        if (this.group.getAttributes() == null) {
            this.group.setAttributes(new HashMap());
        }
        this.group.getAttributes().put(name, values);
        this.updateGroup();
    }

    public void removeAttribute(String name) {
        if (this.group.getAttributes() == null) {
            return;
        }
        this.group.getAttributes().remove(name);
        this.updateGroup();
    }

    public String getFirstAttribute(String name) {
        if (this.group.getAttributes() == null) {
            return null;
        }
        List attrValues = (List)this.group.getAttributes().get(name);
        return attrValues == null || attrValues.isEmpty() ? null : (String)attrValues.get(0);
    }

    public List<String> getAttribute(String name) {
        if (this.group.getAttributes() == null) {
            return Collections.emptyList();
        }
        List attrValues = (List)this.group.getAttributes().get(name);
        return attrValues == null ? Collections.emptyList() : Collections.unmodifiableList(attrValues);
    }

    public Map<String, List<String>> getAttributes() {
        return this.group.getAttributes() == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.group.getAttributes());
    }

    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        return KeycloakModelUtils.hasRole(roles, (RoleModel)role);
    }

    public void grantRole(RoleModel role) {
        this.getMongoStore().pushItemToList(this.group, "roleIds", role.getId(), true, this.invocationContext);
    }

    public Set<RoleModel> getRoleMappings() {
        if (this.group.getRoleIds() == null || this.group.getRoleIds().isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String id : this.group.getRoleIds()) {
            RoleModel roleById = this.realm.getRoleById(id);
            if (roleById == null) {
                throw new ModelException("role does not exist in group role mappings");
            }
            roles.add(roleById);
        }
        return roles;
    }

    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> allRoles = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allRoles) {
            if (!(role.getContainer() instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.group == null || role == null) {
            return;
        }
        this.getMongoStore().pullItemFromList(this.group, "roleIds", role.getId(), this.invocationContext);
    }

    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        Set<RoleModel> roles = this.getRoleMappings();
        for (RoleModel role : roles) {
            if (!app.equals(role.getContainer())) continue;
            result.add(role);
        }
        return result;
    }

    public GroupModel getParent() {
        if (this.group.getParentId() == null) {
            return null;
        }
        return this.realm.getGroupById(this.group.getParentId());
    }

    public String getParentId() {
        return this.group.getParentId();
    }

    public Set<GroupModel> getSubGroups() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.realm.getId()).and("parentId").is((Object)this.getId()).get();
        List<MongoGroupEntity> groups = this.getMongoStore().loadEntities(MongoGroupEntity.class, query, this.invocationContext);
        HashSet<GroupModel> subGroups = new HashSet<GroupModel>();
        if (groups == null) {
            return subGroups;
        }
        for (MongoGroupEntity group : groups) {
            subGroups.add(this.realm.getGroupById(group.getId()));
        }
        return subGroups;
    }

    public void setParent(GroupModel parent) {
        if (parent == null) {
            this.group.setParentId(null);
        } else {
            if (parent.getId().equals(this.getId())) {
                return;
            }
            this.group.setParentId(parent.getId());
        }
        this.updateGroup();
    }

    public void addChild(GroupModel subGroup) {
        if (subGroup.getId().equals(this.getId())) {
            return;
        }
        subGroup.setParent((GroupModel)this);
        this.updateGroup();
    }

    public void removeChild(GroupModel subGroup) {
        if (subGroup.getId().equals(this.getId())) {
            return;
        }
        subGroup.setParent(null);
        this.updateGroup();
    }
}

