/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.audit.SyslogAuditLogHandler;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.audit.EnvironmentNameReader;
import org.jboss.as.domain.management.audit.SyslogAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.KeystoreAttributes;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class SyslogAuditLogProtocolResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host", ModelType.STRING).setAllowNull(true)).setDefaultValue(new ModelNode("localhost"))).setAllowExpression(true)).setMinSize(1)).build();
    public static final SimpleAttributeDefinition PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("port", ModelType.INT).setAllowNull(true)).setDefaultValue(new ModelNode(514))).setAllowExpression(true)).build();
    protected final ManagedAuditLogger auditLogger;
    protected final PathManagerService pathManager;
    protected final EnvironmentNameReader environmentReader;
    protected final AttributeDefinition[] attributes;

    SyslogAuditLogProtocolResourceDefinition(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition[] attributes, PathElement pathElement, ResourceDescriptionResolver resolver, EnvironmentNameReader environmentReader) {
        super(pathElement, resolver, (OperationStepHandler)new ProtocolConfigAddHandler(auditLogger, pathManager, attributes, environmentReader), (OperationStepHandler)new ProtocolConfigRemoveHandler(auditLogger, pathManager, environmentReader));
        this.auditLogger = auditLogger;
        this.pathManager = pathManager;
        this.attributes = attributes;
        this.environmentReader = environmentReader;
        this.setDeprecated(ModelVersion.create((int)1, (int)7));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        SyslogAuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler handler = new SyslogAuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler(this.auditLogger, this.pathManager, this.environmentReader, this.attributes);
        for (AttributeDefinition def : this.attributes) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)handler);
        }
    }

    public static void createServerAddOperations(List<ModelNode> addOps, PathAddress protocolAddress, ModelNode protocol) {
        addOps.add(SyslogAuditLogProtocolResourceDefinition.createProtocolAddOperation(protocolAddress, protocol));
        SyslogAuditLogHandler.Transport transport = SyslogAuditLogHandler.Transport.valueOf((String)protocolAddress.getLastElement().getValue().toUpperCase(Locale.ENGLISH));
        if (transport == SyslogAuditLogHandler.Transport.TLS && protocol.hasDefined("authentication")) {
            ModelNode auth = protocol.get("authentication");
            if (auth.hasDefined("truststore")) {
                addOps.add(SyslogAuditLogProtocolResourceDefinition.createKeystoreAddOperation(protocolAddress.append("authentication", "truststore"), protocol.get(new String[]{"authentication", "truststore"})));
            }
            if (auth.hasDefined("client-certificate-store")) {
                addOps.add(SyslogAuditLogProtocolResourceDefinition.createKeystoreAddOperation(protocolAddress.append("authentication", "client-certificate-store"), protocol.get(new String[]{"authentication", "client-certificate-store"})));
            }
        }
    }

    public static ModelNode createProtocolAddOperation(PathAddress protocolAddress, ModelNode protocol) {
        ModelNode protocolAdd = Util.createAddOperation((PathAddress)protocolAddress);
        protocolAdd.get(HOST.getName()).set(protocol.get(HOST.getName()));
        protocolAdd.get(PORT.getName()).set(protocol.get(PORT.getName()));
        SyslogAuditLogHandler.Transport transport = SyslogAuditLogHandler.Transport.valueOf((String)protocolAddress.getLastElement().getValue().toUpperCase(Locale.ENGLISH));
        if (transport != SyslogAuditLogHandler.Transport.UDP) {
            protocolAdd.get(Tcp.MESSAGE_TRANSFER.getName()).set(protocol.get(Tcp.MESSAGE_TRANSFER.getName()));
        }
        return protocolAdd;
    }

    public static ModelNode createKeystoreAddOperation(PathAddress storeAddress, ModelNode store) {
        ModelNode storeAdd = Util.createAddOperation((PathAddress)storeAddress);
        for (AttributeDefinition def : TlsKeyStore.CLIENT_CERT_ATTRIBUTES) {
            storeAdd.get(def.getName()).set(store.get(def.getName()));
        }
        return storeAdd;
    }

    private static class TlsKeyStoreAddHandler
    extends AbstractAddStepHandler {
        private final ManagedAuditLogger auditLogger;
        private final PathManagerService pathManager;
        private final AttributeDefinition[] attributes;
        private final EnvironmentNameReader environmentReader;

        TlsKeyStoreAddHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition[] attributes, EnvironmentNameReader environmentReader) {
            this.auditLogger = auditLogger;
            this.pathManager = pathManager;
            this.attributes = attributes;
            this.environmentReader = environmentReader;
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition def : this.attributes) {
                def.validateAndSet(operation, model);
            }
        }

        protected boolean requiresRuntime(OperationContext context) {
            return !context.isBooting();
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().updateHandler((AuditLogHandler)SyslogAuditLogHandlerResourceDefinition.createHandler(this.pathManager, context, this.environmentReader));
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }

    private static class ProtocolConfigAddHandler
    extends AbstractAddStepHandler {
        private final ManagedAuditLogger auditLogger;
        private final PathManagerService pathManager;
        private final AttributeDefinition[] attributes;
        private final EnvironmentNameReader environmentReader;

        ProtocolConfigAddHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition[] attributes, EnvironmentNameReader environmentReader) {
            this.auditLogger = auditLogger;
            this.pathManager = pathManager;
            this.attributes = attributes;
            this.environmentReader = environmentReader;
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            this.checkNoOtherProtocol(context, operation);
            ModelNode model = resource.getModel();
            for (AttributeDefinition def : this.attributes) {
                def.validateAndSet(operation, model);
            }
        }

        private void checkNoOtherProtocol(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress opAddr = PathAddress.pathAddress((ModelNode)operation.require("address"));
            PathAddress addr = opAddr.subAddress(0, opAddr.size() - 1);
            Resource resource = context.readResourceFromRoot(addr);
            Set existing = resource.getChildren("protocol");
            if (existing.size() > 1) {
                for (Resource.ResourceEntry entry : existing) {
                    PathElement mine = addr.getLastElement();
                    if (entry.getPathElement().equals(mine)) continue;
                    throw DomainManagementLogger.ROOT_LOGGER.sysLogProtocolAlreadyConfigured(addr.append(new PathElement[]{mine}));
                }
            }
        }

        protected boolean requiresRuntime(OperationContext context) {
            return !context.isBooting();
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().updateHandler((AuditLogHandler)SyslogAuditLogHandlerResourceDefinition.createHandler(this.pathManager, context, this.environmentReader));
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }

    private static class ProtocolConfigRemoveHandler
    extends AbstractRemoveStepHandler {
        private final ManagedAuditLogger auditLogger;
        private final PathManagerService pathManager;
        private final EnvironmentNameReader environmentReader;

        public ProtocolConfigRemoveHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader) {
            this.pathManager = pathManager;
            this.auditLogger = auditLogger;
            this.environmentReader = environmentReader;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress handlerAddress = SyslogAuditLogHandlerResourceDefinition.getAffectedHandlerAddress(context);
            try {
                Resource handleResource = context.readResourceFromRoot(handlerAddress);
                String name = Util.getNameFromAddress((PathAddress)handlerAddress);
                this.auditLogger.getUpdater().updateHandler((AuditLogHandler)SyslogAuditLogHandlerResourceDefinition.createHandler(this.pathManager, context, name, handleResource, this.environmentReader));
            }
            catch (Resource.NoSuchResourceException noSuchResourceException) {
                // empty catch block
            }
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }

    public static class TlsKeyStore
    extends SimpleResourceDefinition {
        public static final PathElement TRUSTSTORE_ELEMENT = PathElement.pathElement((String)"authentication", (String)"truststore");
        public static final PathElement CLIENT_CERT_ELEMENT = PathElement.pathElement((String)"authentication", (String)"client-certificate-store");
        public static final SimpleAttributeDefinition KEYSTORE_PASSWORD = KeystoreAttributes.KEYSTORE_PASSWORD;
        public static final SimpleAttributeDefinition KEYSTORE_PATH = KeystoreAttributes.KEYSTORE_PATH;
        public static final SimpleAttributeDefinition KEYSTORE_RELATIVE_TO = KeystoreAttributes.KEYSTORE_RELATIVE_TO;
        public static final SimpleAttributeDefinition KEY_PASSWORD = KeystoreAttributes.KEY_PASSWORD;
        private static final AttributeDefinition[] CLIENT_CERT_ATTRIBUTES = new AttributeDefinition[]{KEYSTORE_PASSWORD, KEYSTORE_PATH, KEYSTORE_RELATIVE_TO, KEY_PASSWORD};
        private static final AttributeDefinition[] TRUSTSTORE_ATTRIBUTES = new AttributeDefinition[]{KEYSTORE_PASSWORD, KEYSTORE_PATH, KEYSTORE_RELATIVE_TO};
        private final ManagedAuditLogger auditLogger;
        private final PathManagerService pathManager;
        private final AttributeDefinition[] attributes;
        private final EnvironmentNameReader environmentReader;

        private TlsKeyStore(ManagedAuditLogger auditLogger, PathManagerService pathManager, PathElement pathElement, ResourceDescriptionResolver resolver, AttributeDefinition[] attributes, EnvironmentNameReader environmentReader) {
            super(pathElement, resolver, (OperationStepHandler)new TlsKeyStoreAddHandler(auditLogger, pathManager, attributes, environmentReader), (OperationStepHandler)new ProtocolConfigRemoveHandler(auditLogger, pathManager, environmentReader));
            this.auditLogger = auditLogger;
            this.pathManager = pathManager;
            this.attributes = attributes;
            this.environmentReader = environmentReader;
        }

        static TlsKeyStore createTrustStore(ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader) {
            return new TlsKeyStore(auditLogger, pathManager, TRUSTSTORE_ELEMENT, DomainManagementResolver.getResolver("core.management.syslog-truststore"), TRUSTSTORE_ATTRIBUTES, environmentReader);
        }

        static TlsKeyStore createClientCertStore(ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader) {
            return new TlsKeyStore(auditLogger, pathManager, CLIENT_CERT_ELEMENT, DomainManagementResolver.getResolver("core.management.syslog-client-cert-store"), CLIENT_CERT_ATTRIBUTES, environmentReader);
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            SyslogAuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler handler = new SyslogAuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler(this.auditLogger, this.pathManager, this.environmentReader, CLIENT_CERT_ATTRIBUTES);
            for (AttributeDefinition attr : this.attributes) {
                resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
            }
        }
    }

    public static class Tls
    extends Tcp {
        public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"protocol", (String)"tls");
        private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{HOST, PORT, MESSAGE_TRANSFER, RECONNECT_TIMEOUT};

        Tls(ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader) {
            super(auditLogger, pathManager, ATTRIBUTES, PATH_ELEMENT, DomainManagementResolver.getDeprecatedResolver("core.management.audit-log", "core.management.syslog-tls"), environmentReader);
        }

        public void registerChildren(ManagementResourceRegistration resourceRegistration) {
            resourceRegistration.registerSubModel((ResourceDefinition)TlsKeyStore.createTrustStore(this.auditLogger, this.pathManager, this.environmentReader));
            resourceRegistration.registerSubModel((ResourceDefinition)TlsKeyStore.createClientCertStore(this.auditLogger, this.pathManager, this.environmentReader));
        }
    }

    public static class Tcp
    extends Udp {
        public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"protocol", (String)"tcp");
        public static final SimpleAttributeDefinition MESSAGE_TRANSFER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("message-transfer", ModelType.STRING).setAllowNull(true)).setDefaultValue(new ModelNode(SyslogAuditLogHandler.MessageTransfer.NON_TRANSPARENT_FRAMING.name()))).setAllowExpression(true)).build();
        public static final SimpleAttributeDefinition RECONNECT_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("reconnect-timeout", ModelType.INT).setAllowNull(true)).setDefaultValue(new ModelNode(-1))).setAllowExpression(true)).build();
        private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{HOST, PORT, MESSAGE_TRANSFER, RECONNECT_TIMEOUT};

        Tcp(ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader) {
            super(auditLogger, pathManager, ATTRIBUTES, PATH_ELEMENT, DomainManagementResolver.getDeprecatedResolver("core.management.audit-log", "core.management.syslog-tcp"), environmentReader);
        }

        Tcp(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition[] attributes, PathElement pathElement, ResourceDescriptionResolver resolver, EnvironmentNameReader environmentReader) {
            super(auditLogger, pathManager, attributes, pathElement, resolver, environmentReader);
        }
    }

    public static class Udp
    extends SyslogAuditLogProtocolResourceDefinition {
        public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"protocol", (String)"udp");
        private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{HOST, PORT};

        Udp(ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader) {
            super(auditLogger, pathManager, ATTRIBUTES, PATH_ELEMENT, DomainManagementResolver.getDeprecatedResolver("core.management.audit-log", "core.management.syslog-udp"), environmentReader);
        }

        Udp(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition[] attributes, PathElement pathElement, ResourceDescriptionResolver resolver, EnvironmentNameReader environmentReader) {
            super(auditLogger, pathManager, attributes, pathElement, resolver, environmentReader);
        }
    }
}

